/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.commons.future.Future;
import jadex.commons.future.IResultListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FutureFinishChecker {
    protected IResultListener delegate;
    protected List tasks;
    protected boolean finished;
    protected boolean notified;

    public FutureFinishChecker(IResultListener delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(final Future future) {
        FutureFinishChecker futureFinishChecker = this;
        synchronized (futureFinishChecker) {
            if (this.finished) {
                throw new RuntimeException("Add task not allowed after finished.");
            }
            if (this.tasks == null) {
                this.tasks = Collections.synchronizedList(new ArrayList());
            }
            this.tasks.add(future);
        }
        future.addResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                FutureFinishChecker.this.tasks.remove(future);
                FutureFinishChecker.this.check();
            }

            @Override
            public void exceptionOccurred(Exception exception) {
                FutureFinishChecker.this.tasks.remove(future);
                FutureFinishChecker.this.check();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        FutureFinishChecker futureFinishChecker = this;
        synchronized (futureFinishChecker) {
            this.finished = true;
        }
        this.check();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        boolean notify;
        FutureFinishChecker futureFinishChecker = this;
        synchronized (futureFinishChecker) {
            boolean bl = notify = this.finished && (this.tasks == null || this.tasks.size() == 0) && !this.notified;
            if (notify) {
                this.notified = true;
            }
        }
        if (notify) {
            this.delegate.resultAvailable(null);
        }
    }
}

