/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.commons.ICommand;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.IntermediateEmptyResultListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FutureBarrier<E> {
    protected List<IFuture<E>> futures;

    public void addFuture(IFuture<E> fut) {
        if (fut != null) {
            if (this.futures == null) {
                this.futures = new ArrayList<IFuture<E>>();
            }
            this.futures.add(fut);
        }
    }

    public IFuture<Void> waitFor() {
        Future<Void> ret = new Future<Void>();
        if (this.futures != null) {
            final CounterResultListener lis = new CounterResultListener(this.futures.size(), new DelegationResultListener<Void>(ret));
            for (IFuture<Collection<Object>> iFuture : this.futures) {
                if (iFuture instanceof ISubscriptionIntermediateFuture) {
                    IntermediateEmptyResultListener<Object> tmplis = new IntermediateEmptyResultListener<Object>(){

                        @Override
                        public void finished() {
                            lis.resultAvailable(null);
                        }

                        @Override
                        public void exceptionOccurred(Exception exception) {
                            lis.exceptionOccurred(exception);
                        }

                        @Override
                        public void resultAvailable(Collection<Object> result) {
                            lis.resultAvailable(null);
                        }
                    };
                    iFuture.addResultListener(tmplis);
                    continue;
                }
                iFuture.addResultListener(lis);
            }
        } else {
            ret.setResult(null);
        }
        return ret;
    }

    public IFuture<Void> waitForIgnoreFailures(final ICommand<Exception> failurehandler) {
        Future<Void> ret = new Future<Void>();
        if (this.futures != null) {
            CounterResultListener lis = new CounterResultListener<E>(this.futures.size(), true, new DelegationResultListener<Void>(ret)){

                @Override
                public void exceptionOccurred(Exception exception) {
                    if (failurehandler != null) {
                        failurehandler.execute((Object)exception);
                    }
                    super.exceptionOccurred(exception);
                }
            };
            for (IFuture<E> fut : this.futures) {
                fut.addResultListener(lis);
            }
        } else {
            ret.setResult(null);
        }
        return ret;
    }

    public IFuture<Collection<E>> waitForResults() {
        final Future<Collection<Object>> ret = new Future<Collection<Object>>();
        if (this.futures != null) {
            CounterResultListener lis = new CounterResultListener(this.futures.size(), new ExceptionDelegationResultListener<Void, Collection<E>>(ret){

                @Override
                public void customResultAvailable(Void result) throws Exception {
                    ArrayList res = new ArrayList();
                    for (IFuture fut : FutureBarrier.this.futures) {
                        res.add(fut.get());
                    }
                    ret.setResult(res);
                }
            });
            for (IFuture fut : this.futures) {
                fut.addResultListener(lis);
            }
        } else {
            ret.setResult(null);
        }
        return ret;
    }

    public IFuture<Collection<E>> waitForResultsIgnoreFailures(final ICommand<Exception> failurehandler) {
        final Future<Collection<Object>> ret = new Future<Collection<Object>>();
        if (this.futures != null) {
            CounterResultListener lis = new CounterResultListener(this.futures.size(), true, new ExceptionDelegationResultListener<Void, Collection<E>>(ret){

                @Override
                public void customResultAvailable(Void result) throws Exception {
                    ArrayList res = new ArrayList();
                    for (IFuture fut : FutureBarrier.this.futures) {
                        if (fut.getException() != null) continue;
                        res.add(fut.get());
                    }
                    ret.setResult(res);
                }

                @Override
                public void exceptionOccurred(Exception exception) {
                    if (failurehandler != null) {
                        failurehandler.execute((Object)exception);
                    }
                    super.exceptionOccurred(exception);
                }
            });
            for (IFuture fut : this.futures) {
                fut.addResultListener(lis);
            }
        } else {
            ret.setResult(null);
        }
        return ret;
    }

    public E getResult(int index) {
        if (!this.futures.get(index).isDone()) {
            throw new RuntimeException("Future not finished.");
        }
        return this.futures.get(index).get();
    }

    public int getCount() {
        return this.futures != null ? this.futures.size() : 0;
    }
}

