/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.commons.DebugException;
import jadex.commons.ErrorException;
import jadex.commons.ICommand;
import jadex.commons.IFilter;
import jadex.commons.SUtil;
import jadex.commons.TimeoutException;
import jadex.commons.Tuple3;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.DuplicateResultException;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.FutureHelper;
import jadex.commons.future.IForwardCommandFuture;
import jadex.commons.future.IFuture;
import jadex.commons.future.IFutureCommandResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISuspendable;
import jadex.commons.future.IUndoneResultListener;
import jadex.commons.future.ThreadSuspendable;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;

public class Future<E>
implements IFuture<E>,
IForwardCommandFuture {
    public static final Map<Thread, List<Tuple3<Future<?>, IResultListener<?>, ICommand<IResultListener<?>>>>> NOTIFICATIONS = new IdentityHashMap();
    static final ThreadLocal<Boolean> NOTIFYING = new ThreadLocal();
    protected static final String CALLER_QUEUED = "queued";
    protected static final String CALLER_RESUMED = "resumed";
    protected static final String CALLER_SUSPENDED = "suspended";
    public static boolean DEBUG = true;
    public static boolean NO_STACK_COMPACTION = false;
    public static final long NONE = -1L;
    public static final long UNSET = -2L;
    protected E result;
    protected Exception exception;
    protected volatile boolean resultavailable;
    protected Map<ISuspendable, String> callers;
    protected Map<IResultListener<E>, Thread> listeners;
    protected Map<IResultListener<E>, Integer> notificount;
    protected Exception creation;
    protected Exception first;
    protected boolean undone;
    protected boolean notified = false;
    protected ICommand<IResultListener<E>> notcommand = new ICommand<IResultListener<E>>(){

        public void execute(IResultListener<E> listener) {
            if (Future.this.exception != null) {
                if (Future.this.undone && listener instanceof IUndoneResultListener) {
                    ((IUndoneResultListener)listener).exceptionOccurredIfUndone(Future.this.exception);
                } else {
                    listener.exceptionOccurred(Future.this.exception);
                }
            } else if (Future.this.undone && listener instanceof IUndoneResultListener) {
                ((IUndoneResultListener)listener).resultAvailableIfUndone(Future.this.result);
            } else {
                listener.resultAvailable(Future.this.result);
            }
        }

        public String toString() {
            return "NotiCommand(" + Future.this + ", " + Future.this.result + ", " + Future.this.exception + ")";
        }
    };

    public static <T> IFuture<T> getEmptyFuture() {
        return new Future<Object>(null);
    }

    public Future() {
        if (DEBUG) {
            this.creation = new DebugException("future creation: " + this);
        }
    }

    public Future(E result) {
        this();
        this.setResult(result);
    }

    public Future(Exception exception) {
        this();
        this.setException(exception);
    }

    @Override
    public boolean isDone() {
        return this.resultavailable;
    }

    @Override
    public synchronized Exception getException() {
        return this.exception;
    }

    @Override
    public E get(ThreadSuspendable sus) {
        return this.get(-1L);
    }

    @Override
    public E get() {
        return this.get(-1L);
    }

    @Override
    public E get(boolean realtime) {
        return this.get(-1L);
    }

    @Override
    public E get(long timeout) {
        return this.get(timeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(long timeout, boolean realtime) {
        boolean suspend = false;
        ISuspendable caller = ISuspendable.SUSPENDABLE.get();
        if (caller == null) {
            caller = new ThreadSuspendable();
        }
        if (!this.isDone()) {
            FutureHelper.notifyStackedListeners();
        }
        Future future = this;
        synchronized (future) {
            if (!this.isDone()) {
                if (this.callers == null) {
                    this.callers = Collections.synchronizedMap(new HashMap());
                }
                this.callers.put(caller, CALLER_QUEUED);
                suspend = true;
            }
        }
        if (suspend) {
            Object mon;
            Object object = mon = caller.getMonitor() != null ? caller.getMonitor() : caller;
            synchronized (object) {
                String state = this.callers.get(caller);
                if (CALLER_QUEUED.equals(state)) {
                    this.callers.put(caller, CALLER_SUSPENDED);
                    try {
                        caller.suspend(this, timeout, realtime);
                    }
                    finally {
                        this.callers.remove(caller);
                    }
                }
            }
        }
        future = this;
        synchronized (future) {
            if (this.exception != null) {
                throw Future.throwException(this.exception);
            }
            if (this.isDone()) {
                return this.result;
            }
            throw new TimeoutException("Timeout while waiting for future.");
        }
    }

    public static RuntimeException throwException(Throwable t) {
        if (t instanceof RuntimeException || t instanceof Error) {
            StackTraceElement[] stack0 = t.getStackTrace();
            StackTraceElement[] stack1 = new RuntimeException().fillInStackTrace().getStackTrace();
            t.setStackTrace((StackTraceElement[])SUtil.joinArrays((Object[])new Object[]{stack1, new StackTraceElement[]{new StackTraceElement("End of future stack trace", "\n", "Original exception: " + t.toString(), -1)}, stack0}));
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw (Error)t;
        }
        if (t instanceof ErrorException) {
            throw Future.throwException(((ErrorException)t).getError());
        }
        throw new RuntimeException(t.getMessage(), t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doSetException(Exception exception, boolean undone) {
        if (exception == null) {
            throw new IllegalArgumentException();
        }
        Future future = this;
        synchronized (future) {
            if (undone) {
                this.undone = undone;
            }
            if (this.isDone()) {
                if (undone) {
                    return false;
                }
                if (this.exception != null) {
                    throw new DuplicateResultException(4, this, this.exception, exception);
                }
                throw new DuplicateResultException(2, this, this.result, exception);
            }
            this.exception = exception;
            this.resultavailable = true;
            if (DEBUG) {
                this.first = new DebugException("first setException()");
            }
        }
        this.resume();
        return true;
    }

    public void setException(Exception exception) {
        this.doSetException(exception, false);
    }

    public boolean setExceptionIfUndone(Exception exception) {
        return this.doSetException(exception, true);
    }

    public void setResult(E result) {
        this.doSetResult(result, false);
        this.resume();
    }

    public boolean setResultIfUndone(E result) {
        boolean ret = this.doSetResult(result, true);
        if (ret) {
            this.resume();
        }
        return ret;
    }

    protected synchronized boolean doSetResult(E result, boolean undone) {
        if (undone) {
            this.undone = true;
        }
        if (result instanceof Future) {
            Logger.getLogger("future").warning("Future as result of future not supported");
        }
        if (this.isDone()) {
            if (undone) {
                return false;
            }
            if (this.exception != null) {
                throw new DuplicateResultException(3, this, this.exception, result);
            }
            throw new DuplicateResultException(1, this, this.result, result);
        }
        if (DEBUG) {
            this.first = new DebugException("first result");
        }
        this.result = result;
        this.resultavailable = true;
        return true;
    }

    public boolean isNotified() {
        return this.notified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resume() {
        boolean scheduled;
        Future future = this;
        synchronized (future) {
            if (this.callers != null) {
                for (ISuspendable caller : this.callers.keySet()) {
                    Object mon;
                    Object object = mon = caller.getMonitor() != null ? caller.getMonitor() : caller;
                    synchronized (object) {
                        String state = this.callers.get(caller);
                        if (CALLER_SUSPENDED.equals(state)) {
                            caller.resume(this);
                        }
                        this.callers.put(caller, CALLER_RESUMED);
                    }
                }
                this.notified = true;
            }
            scheduled = this.scheduleNotification((IFilter)null, this.getNotificationCommand());
            this.notified = this.notified || scheduled;
            this.listeners = null;
            this.notificount = null;
        }
        if (scheduled) {
            Future.startScheduledNotifications();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortGet(ISuspendable caller) {
        Future future = this;
        synchronized (future) {
            if (this.callers != null && this.callers.containsKey(caller)) {
                Object mon;
                Object object = mon = caller.getMonitor() != null ? caller.getMonitor() : caller;
                synchronized (object) {
                    String state = this.callers.get(caller);
                    if (CALLER_SUSPENDED.equals(state)) {
                        caller.resume(this);
                    }
                    this.callers.put(caller, CALLER_RESUMED);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean scheduleNotification(IFilter<IResultListener<E>> filter, ICommand<IResultListener<E>> command) {
        boolean scheduled = false;
        Future future = this;
        synchronized (future) {
            if (this.listeners != null) {
                for (IResultListener<E> listener : this.listeners.keySet()) {
                    if (filter != null && !filter.filter(listener)) continue;
                    this.scheduleNotification(listener, command);
                    scheduled = true;
                }
            }
        }
        return scheduled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleNotification(IResultListener<E> listener, ICommand<IResultListener<E>> command) {
        assert (listener != null);
        Thread notificator = null;
        Object object = this;
        synchronized (object) {
            if (this.isDone() && (this.listeners == null || !this.listeners.containsKey(listener))) {
                notificator = Thread.currentThread();
            } else {
                int cnt;
                if (this.listeners != null) {
                    notificator = this.listeners.get(listener);
                }
                if (notificator == null) {
                    notificator = Thread.currentThread();
                    this.listeners.put(listener, notificator);
                }
                int n = cnt = this.notificount != null && this.notificount.containsKey(listener) ? this.notificount.get(listener) : 0;
                if (this.notificount == null) {
                    this.notificount = new IdentityHashMap<IResultListener<E>, Integer>();
                }
                this.notificount.put(listener, cnt + 1);
            }
        }
        object = NOTIFICATIONS;
        synchronized (object) {
            List<Tuple3<Future<?>, IResultListener<?>, ICommand<IResultListener<?>>>> queue = NOTIFICATIONS.get(notificator);
            if (queue == null) {
                queue = new LinkedList();
                NOTIFICATIONS.put(notificator, queue);
            }
            Tuple3 entry = new Tuple3((Object)this, listener, command);
            queue.add(entry);
        }
    }

    protected static final void startScheduledNotifications() {
        boolean compaction;
        boolean bl = compaction = !NO_STACK_COMPACTION && !SUtil.isGuiThread();
        if (compaction) {
            if (NOTIFYING.get() == null) {
                NOTIFYING.set(true);
                try {
                    Future.doStartScheduledNotifications();
                }
                finally {
                    NOTIFYING.remove();
                }
            }
        } else {
            Future.doStartScheduledNotifications();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> void doStartScheduledNotifications() {
        Tuple3<Future<?>, IResultListener<?>, ICommand<IResultListener<?>>> next = null;
        do {
            Map<Thread, List<Tuple3<Future<?>, IResultListener<?>, ICommand<IResultListener<?>>>>> map = NOTIFICATIONS;
            synchronized (map) {
                List<Tuple3<Future<?>, IResultListener<?>, ICommand<IResultListener<?>>>> queue = NOTIFICATIONS.get(Thread.currentThread());
                Tuple3<Future<?>, IResultListener<?>, ICommand<IResultListener<?>>> tuple3 = next = queue != null && !queue.isEmpty() ? queue.remove(0) : null;
                if (next == null) {
                    NOTIFICATIONS.remove(Thread.currentThread());
                }
            }
            if (next == null) continue;
            Future fut = (Future)next.getFirstEntity();
            IResultListener lis = (IResultListener)next.getSecondEntity();
            ICommand com = (ICommand)next.getThirdEntity();
            fut.executeNotification(lis, com);
            Future future = fut;
            synchronized (future) {
                int cnt;
                int n = cnt = fut.notificount != null && fut.notificount.containsKey(lis) ? fut.notificount.get(lis) : 0;
                if (cnt > 1) {
                    fut.notificount.put(lis, cnt - 1);
                } else if (cnt == 1) {
                    fut.notificount.remove(lis);
                    if (fut.listeners != null) {
                        fut.listeners.put(lis, null);
                    }
                }
            }
        } while (next != null);
    }

    protected void executeNotification(IResultListener<E> listener, ICommand<IResultListener<E>> command) {
        command.execute(listener);
    }

    @Override
    public void addResultListener(IResultListener<E> listener) {
        if (this.doAddResultListener(listener)) {
            this.scheduleNotification(listener, this.getNotificationCommand());
            Future.startScheduledNotifications();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doAddResultListener(IResultListener<E> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        boolean notify = false;
        Future future = this;
        synchronized (future) {
            if (this.isDone()) {
                notify = true;
            } else {
                if (this.listeners == null) {
                    this.listeners = new IdentityHashMap<IResultListener<E>, Thread>();
                }
                this.listeners.put(listener, null);
            }
        }
        return notify;
    }

    protected ICommand<IResultListener<E>> getNotificationCommand() {
        return this.notcommand;
    }

    @Override
    public void sendForwardCommand(final Object command) {
        this.scheduleNotification(new IFilter<IResultListener<E>>(){

            public boolean filter(IResultListener<E> obj) {
                return obj instanceof IFutureCommandResultListener;
            }
        }, new ICommand<IResultListener<E>>(){

            public void execute(IResultListener<E> listener) {
                ((IFutureCommandResultListener)listener).commandAvailable(command);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResultListener() {
        Future future = this;
        synchronized (future) {
            return this.listeners != null && !this.listeners.isEmpty();
        }
    }

    @Override
    public IFuture<? extends E> then(final Consumer<? super E> function) {
        this.addResultListener(new IResultListener<E>(){

            @Override
            public void resultAvailable(E result) {
                function.accept(result);
            }

            @Override
            public void exceptionOccurred(Exception exception) {
            }
        });
        return this;
    }

    @Override
    public <T> IFuture<T> thenApply(Function<? super E, ? extends T> function) {
        return this.thenApply(function, null);
    }

    @Override
    public <T> IFuture<T> thenApply(final Function<? super E, ? extends T> function, Class<?> futuretype) {
        final Future<T> ret = this.getFuture(futuretype);
        this.addResultListener(new ExceptionDelegationResultListener<E, T>(ret){

            @Override
            public void customResultAvailable(E result) {
                Object res = function.apply(result);
                ret.setResult(res);
            }
        });
        return ret;
    }

    @Override
    public <T> IFuture<T> thenCompose(Function<? super E, IFuture<T>> function) {
        return this.thenCompose(function, null);
    }

    @Override
    public <T> IFuture<T> thenCompose(final Function<? super E, IFuture<T>> function, Class<?> futuretype) {
        final Future<T> ret = this.getFuture(futuretype);
        this.addResultListener(new ExceptionDelegationResultListener<E, T>(ret){

            @Override
            public void customResultAvailable(E result) {
                IFuture res = (IFuture)function.apply(result);
                res.delegateTo(ret);
            }
        });
        return ret;
    }

    public IFuture<Void> thenAccept(Consumer<? super E> consumer) {
        return this.thenAccept(consumer, null);
    }

    public IFuture<Void> thenAccept(final Consumer<? super E> consumer, Class<?> futuretype) {
        final Future<Void> ret = this.getFuture(futuretype);
        this.addResultListener(new ExceptionDelegationResultListener<E, Void>(ret){

            @Override
            public void customResultAvailable(E result) {
                consumer.accept(result);
                ret.setResult(null);
            }
        });
        return ret;
    }

    public <U, V> IFuture<V> thenCombine(final IFuture<U> other, final BiFunction<? super E, ? super U, ? extends V> function, Class<?> futuretype) {
        final Future ret = this.getFuture(futuretype);
        this.addResultListener(new ExceptionDelegationResultListener<E, V>(ret){

            @Override
            public void customResultAvailable(final E e) {
                other.addResultListener(new ExceptionDelegationResultListener<U, V>(ret){

                    @Override
                    public void customResultAvailable(U u) {
                        ret.setResult(function.apply(e, u));
                    }
                });
            }
        });
        return ret;
    }

    @Override
    public void delegate(Future<E> delegate) {
        this.delegateTo(delegate);
    }

    @Override
    public void delegateTo(Future<E> target) {
        target.delegateFrom(this);
    }

    public void delegateFrom(IFuture<E> source) {
        if (source == null) {
            throw new IllegalArgumentException("Source must not null");
        }
        source.addResultListener(new DelegationResultListener(this));
    }

    @Override
    public <T> IFuture<E> catchEx(final Future<T> delegate) {
        this.addResultListener(new IResultListener<E>(){

            @Override
            public void exceptionOccurred(Exception exception) {
                delegate.setException(exception);
            }

            @Override
            public void resultAvailable(E result) {
            }
        });
        return this;
    }

    @Override
    public IFuture<E> catchEx(Consumer<? super Exception> consumer) {
        return this.catchEx(consumer, null);
    }

    @Override
    public IFuture<E> catchEx(final Consumer<? super Exception> consumer, Class<?> futuretype) {
        this.addResultListener(new IResultListener<E>(){

            @Override
            public void exceptionOccurred(Exception exception) {
                consumer.accept(exception);
            }

            @Override
            public void resultAvailable(E result) {
            }
        });
        return this;
    }

    public <T> Future<T> getFuture(Class<?> futuretype) {
        Future ret;
        if (futuretype == null) {
            ret = new Future();
        } else {
            try {
                Future fut;
                ret = fut = (Future)futuretype.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }
}

