/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.commons.future.DuplicateResultException;
import jadex.commons.future.Future;
import jadex.commons.future.IForwardCommandFuture;
import jadex.commons.future.IFutureCommandResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.IUndoneResultListener;
import java.util.logging.Logger;

public abstract class ExceptionDelegationResultListener<E, T>
implements IResultListener<E>,
IFutureCommandResultListener<E>,
IUndoneResultListener<E> {
    protected Future<T> future;
    protected boolean undone;

    public ExceptionDelegationResultListener(Future<T> future) {
        this(future, false);
    }

    public ExceptionDelegationResultListener(Future<T> future, boolean undone) {
        this.future = future;
        this.undone = undone;
    }

    @Override
    public final void resultAvailable(E result) {
        try {
            this.customResultAvailable(result);
        }
        catch (DuplicateResultException e) {
            if (e.getFuture() == this.future) {
                throw e;
            }
            this.future.setExceptionIfUndone(e);
        }
        catch (Exception e) {
            this.future.setExceptionIfUndone(e);
        }
    }

    public abstract void customResultAvailable(E var1) throws Exception;

    @Override
    public void exceptionOccurred(Exception exception) {
        if (this.undone) {
            this.future.setExceptionIfUndone(exception);
        } else {
            this.future.setException(exception);
        }
    }

    @Override
    public void resultAvailableIfUndone(E result) {
        this.undone = true;
        this.resultAvailable(result);
    }

    @Override
    public void exceptionOccurredIfUndone(Exception exception) {
        this.undone = true;
        this.exceptionOccurred(exception);
    }

    public boolean isUndone() {
        return this.undone;
    }

    @Override
    public void commandAvailable(Object command) {
        if (this.future instanceof IForwardCommandFuture) {
            this.future.sendForwardCommand(command);
        } else {
            Logger.getLogger("exception-delegation-result-listener").fine("Cannot forward command: " + this.future + " " + command);
        }
    }
}

