/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.binary.SBinarySerializer;
import jadex.commons.SUtil;
import jadex.commons.collection.BloomFilter;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IntermediateDelegationResultListener;
import jadex.commons.future.IntermediateFuture;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DuplicateRemovalIntermediateResultListener<E>
extends IntermediateDelegationResultListener<E> {
    protected BloomFilter filter = new BloomFilter();

    public DuplicateRemovalIntermediateResultListener(IIntermediateResultListener<E> delegate) {
        this(delegate, false);
    }

    public DuplicateRemovalIntermediateResultListener(IIntermediateResultListener<E> delegate, boolean undone) {
        super(delegate, undone);
    }

    public DuplicateRemovalIntermediateResultListener(IntermediateFuture<E> future) {
        this(future, false);
    }

    public DuplicateRemovalIntermediateResultListener(IntermediateFuture<E> future, boolean undone) {
        super(future, undone);
    }

    public void setBloomFilter(BloomFilter filter) {
        this.filter = filter;
    }

    @Override
    public void customIntermediateResultAvailable(E result) {
        if (this.filter.add(this.objectToByteArray(result))) {
            super.customIntermediateResultAvailable(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] objectToByteArray(Object value) {
        byte[] ret = null;
        if (value instanceof Serializable) {
            ByteArrayOutputStream bos = null;
            ObjectOutputStream out = null;
            try {
                bos = new ByteArrayOutputStream();
                out = new ObjectOutputStream(bos);
                out.writeObject(value);
                ret = bos.toByteArray();
            }
            catch (Exception e) {
                SUtil.rethrowAsUnchecked((Throwable)e);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (Exception e) {
                        SUtil.rethrowAsUnchecked((Throwable)e);
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        SUtil.rethrowAsUnchecked((Throwable)e);
                    }
                }
            }
        } else {
            ret = SBinarySerializer.writeObjectToByteArray((Object)value, null);
        }
        return ret;
    }
}

