/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.commons.future.DuplicateResultException;
import jadex.commons.future.Future;
import jadex.commons.future.IForwardCommandFuture;
import jadex.commons.future.IFutureCommandResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.IUndoneResultListener;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class DelegationResultListener<E>
implements IResultListener<E>,
IFutureCommandResultListener<E>,
IUndoneResultListener<E> {
    protected Future<E> future;
    protected boolean undone;
    protected Consumer<E> customResultListener;

    public DelegationResultListener(Future<E> future) {
        this(future, false);
    }

    public DelegationResultListener(Future<E> future, Consumer<E> customResultListener) {
        this(future, false, customResultListener);
    }

    public DelegationResultListener(Future<E> future, boolean undone, Consumer<E> customResultListener) {
        this(future, undone);
        this.customResultListener = customResultListener;
    }

    public DelegationResultListener(Future<E> future, boolean undone) {
        this.future = future;
        this.undone = undone;
    }

    @Override
    public final void resultAvailable(E result) {
        try {
            this.customResultAvailable(result);
        }
        catch (DuplicateResultException e) {
            if (e.getFuture() == this.future) {
                throw e;
            }
            if (this.undone) {
                this.future.setExceptionIfUndone(e);
            } else {
                this.future.setException(e);
            }
        }
        catch (Exception e) {
            if (this.undone) {
                this.future.setExceptionIfUndone(e);
            }
            this.future.setException(e);
        }
    }

    public void customResultAvailable(E result) {
        if (this.customResultListener != null) {
            this.customResultListener.accept(result);
        } else if (this.undone) {
            this.future.setResultIfUndone(result);
        } else {
            this.future.setResult(result);
        }
    }

    @Override
    public void exceptionOccurred(Exception exception) {
        if (this.undone) {
            this.future.setExceptionIfUndone(exception);
        } else {
            this.future.setException(exception);
        }
    }

    @Override
    public void commandAvailable(Object command) {
        if (this.future instanceof IForwardCommandFuture) {
            this.future.sendForwardCommand(command);
        } else {
            Logger.getLogger("delegation-result-listener").fine("Cannot forward command: " + this.future + " " + command);
        }
    }

    @Override
    public void resultAvailableIfUndone(E result) {
        this.undone = true;
        this.resultAvailable(result);
    }

    @Override
    public void exceptionOccurredIfUndone(Exception exception) {
        this.undone = true;
        this.exceptionOccurred(exception);
    }

    public boolean isUndone() {
        return this.undone;
    }
}

