/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.commons.DebugException;
import jadex.commons.future.Future;
import jadex.commons.future.IFutureCommandResultListener;
import java.util.logging.Logger;

public abstract class DefaultResultListener<E>
implements IFutureCommandResultListener<E> {
    private Logger logger;
    private Exception exception;

    public DefaultResultListener() {
        this(null);
    }

    public DefaultResultListener(Logger logger) {
        this.logger = logger;
        if (logger == null) {
            this.logger = Logger.getLogger("default-result-listener");
        }
        if (Future.DEBUG) {
            this.exception = new DebugException();
        }
    }

    @Override
    public void exceptionOccurred(Exception exception) {
        if (Future.DEBUG) {
            this.exception.printStackTrace();
            exception.printStackTrace();
        }
        this.logger.warning("Exception occurred: " + this + ", " + exception);
    }

    @Override
    public void commandAvailable(Object command) {
        this.logger.fine("Cannot forward command: " + this + " " + command);
    }
}

