/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.commons.future.IResultListener;
import jadex.commons.future.IUndoneResultListener;

public class CounterResultListener<E>
implements IResultListener<E>,
IUndoneResultListener<E> {
    protected int num;
    protected int cnt;
    protected IResultListener<Void> delegate;
    protected boolean notified;
    protected boolean ignorefailures;
    protected boolean undone;

    public CounterResultListener(int num, IResultListener<Void> delegate) {
        this(num, false, delegate);
    }

    public CounterResultListener(int num, boolean ignorefailures, IResultListener<Void> delegate) {
        this.num = num;
        this.ignorefailures = ignorefailures;
        this.delegate = delegate;
        if (num == 0) {
            this.notified = true;
            delegate.resultAvailable(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resultAvailable(E result) {
        boolean notify = false;
        CounterResultListener counterResultListener = this;
        synchronized (counterResultListener) {
            if (!this.notified) {
                this.notified = notify = ++this.cnt == this.num;
            }
        }
        if (notify) {
            this.intermediateResultAvailable(result);
            if (this.undone && this.delegate instanceof IUndoneResultListener) {
                ((IUndoneResultListener)this.delegate).resultAvailableIfUndone(null);
            } else {
                this.delegate.resultAvailable(null);
            }
        } else if (!this.notified) {
            this.intermediateResultAvailable(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionOccurred(Exception exception) {
        boolean noti;
        boolean notify = false;
        boolean retry = false;
        CounterResultListener counterResultListener = this;
        synchronized (counterResultListener) {
            noti = this.notified;
        }
        if (!noti) {
            retry = this.intermediateExceptionOccurred(exception);
        }
        counterResultListener = this;
        synchronized (counterResultListener) {
            if (!this.notified) {
                if (this.ignorefailures) {
                    boolean bl = retry ? this.cnt == this.num : ++this.cnt == this.num;
                    this.notified = notify = bl;
                } else {
                    notify = true;
                    this.notified = true;
                }
            }
        }
        if (notify) {
            if (this.ignorefailures) {
                if (this.undone && this.delegate instanceof IUndoneResultListener) {
                    ((IUndoneResultListener)this.delegate).resultAvailableIfUndone(null);
                } else {
                    this.delegate.resultAvailable(null);
                }
            } else if (this.undone && this.delegate instanceof IUndoneResultListener) {
                ((IUndoneResultListener)this.delegate).exceptionOccurredIfUndone(exception);
            } else {
                this.delegate.exceptionOccurred(exception);
            }
        }
    }

    public void intermediateResultAvailable(E result) {
    }

    public boolean intermediateExceptionOccurred(Exception exception) {
        return false;
    }

    public int getNumber() {
        return this.num;
    }

    public void setNumber(int num) {
        this.num = num;
        if (num == 0) {
            this.notified = true;
            this.delegate.resultAvailable(null);
        }
    }

    public int getCnt() {
        return this.cnt;
    }

    @Override
    public void resultAvailableIfUndone(E result) {
        this.undone = true;
        this.resultAvailable(result);
    }

    @Override
    public void exceptionOccurredIfUndone(Exception exception) {
        this.undone = true;
        this.exceptionOccurred(exception);
    }

    public boolean isUndone() {
        return this.undone;
    }
}

