/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.commons.future.IResultListener;
import jadex.commons.future.IUndoneResultListener;
import java.util.ArrayList;
import java.util.Collection;

public class CollectionResultListener<E>
implements IResultListener<E>,
IUndoneResultListener<E> {
    protected int num = -1;
    protected Collection<E> results;
    protected IResultListener<Collection<E>> delegate;
    protected boolean notified;
    protected boolean ignorefailures;
    protected boolean undone;
    protected static final Object NULL = new Exception();

    public CollectionResultListener(IResultListener<Collection<E>> delegate) {
        this(-1, false, delegate);
    }

    public CollectionResultListener(boolean ignorefailures, IResultListener<Collection<E>> delegate) {
        this(-1, ignorefailures, delegate);
    }

    public CollectionResultListener(int num, IResultListener<Collection<E>> delegate) {
        this(num, false, delegate);
    }

    public CollectionResultListener(int num, boolean ignorefailures, IResultListener<Collection<E>> delegate) {
        this.num = num;
        this.ignorefailures = ignorefailures;
        this.delegate = delegate;
        this.results = new ArrayList();
        if (num == 0) {
            this.notifyDelegate((Exception)NULL);
        }
    }

    @Override
    public void resultAvailable(E result) {
        if (this.checkNotify(result, (Exception)NULL)) {
            this.notifyDelegate((Exception)NULL);
        }
    }

    @Override
    public void exceptionOccurred(Exception exception) {
        if (this.checkNotify(NULL, exception)) {
            this.notifyDelegate(exception);
        }
    }

    @Override
    public void resultAvailableIfUndone(E result) {
        this.undone = true;
        this.resultAvailable(result);
    }

    @Override
    public void exceptionOccurredIfUndone(Exception exception) {
        this.undone = true;
        this.exceptionOccurred(exception);
    }

    public boolean isUndone() {
        return this.undone;
    }

    public int getResultCount() {
        return this.results.size();
    }

    public void setNumber(int num) {
        this.num += num + 1;
        if (this.checkNotify(NULL, (Exception)NULL)) {
            this.notifyDelegate(null);
        }
    }

    protected synchronized boolean checkNotify(E result, Exception ex) {
        boolean notify = false;
        if (!this.notified) {
            if (result != NULL) {
                this.results.add(result);
                this.notified = notify = this.num == this.results.size();
            } else if (ex != NULL) {
                if (this.ignorefailures) {
                    --this.num;
                    this.notified = notify = this.num == this.results.size();
                } else if (!this.notified) {
                    notify = true;
                    this.notified = true;
                }
            } else if (result == NULL && ex == NULL) {
                this.notified = notify = this.num == this.results.size();
            }
        }
        return notify;
    }

    protected void notifyDelegate(Exception exception) {
        if (exception != NULL && !this.ignorefailures) {
            if (this.undone && this.delegate instanceof IUndoneResultListener) {
                ((IUndoneResultListener)this.delegate).exceptionOccurredIfUndone(exception);
            } else {
                this.delegate.exceptionOccurred(exception);
            }
        } else if (this.undone && this.delegate instanceof IUndoneResultListener) {
            ((IUndoneResultListener)this.delegate).resultAvailableIfUndone(this.results);
        } else {
            this.delegate.resultAvailable(this.results);
        }
    }
}

