/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.future;

import jadex.commons.IResultCommand;
import jadex.commons.Tuple3;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CallSequentializer<T> {
    protected IFuture<T> currentcall;
    protected List<Tuple3<String, Object[], Future<T>>> calls = new ArrayList<Tuple3<String, Object[], Future<T>>>();
    protected Map<String, IResultCommand<IFuture<T>, Object[]>> commands = new HashMap<String, IResultCommand<IFuture<T>, Object[]>>();

    public CallSequentializer() {
    }

    public CallSequentializer(IResultCommand<IFuture<T>, Object[]> call) {
        this();
        this.commands.put(null, call);
    }

    public void addCommand(String method, IResultCommand<IFuture<T>, Object[]> call) {
        this.commands.put(method, call);
    }

    public IFuture<T> call(Object[] args) {
        return this.call(null, args);
    }

    public IFuture<T> call(String method, Object[] args) {
        IResultCommand<IFuture<T>, Object[]> call = this.commands.get(method);
        if (call == null) {
            return new Future(new RuntimeException("Method name not found: " + method));
        }
        if (this.currentcall == null) {
            this.currentcall = (IFuture)call.execute((Object)args);
            this.currentcall.then(res -> this.proceed()).catchEx(ex -> this.proceed());
            return this.currentcall;
        }
        Future ret = new Future();
        this.calls.add(new Tuple3((Object)method, (Object)args, ret));
        return ret;
    }

    protected void proceed() {
        if (this.calls.size() > 0) {
            Tuple3<String, Object[], Future<T>> next = this.calls.remove(0);
            IResultCommand<IFuture<T>, Object[]> call = this.commands.get(next.getFirstEntity());
            IFuture fut = (IFuture)call.execute((Object)((Object[])next.getSecondEntity()));
            fut.addResultListener(new DelegationResultListener((Future)next.getThirdEntity()));
            fut.then(res -> this.proceed()).catchEx(ex -> this.proceed());
        } else {
            this.currentcall = null;
        }
    }
}

