/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.concurrent;

import jadex.commons.concurrent.IThreadPool;
import jadex.commons.concurrent.ThreadPoolFactory;

public class ThreadTest {
    public static void main(String[] args) {
        new ThreadTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadTest() {
        IThreadPool tp = ThreadPoolFactory.createThreadPool();
        MyTask[] tasks = new MyTask[10];
        MyMonitor[] monitors = new MyMonitor[tasks.length];
        for (int i = 0; i < monitors.length; ++i) {
            monitors[i] = new MyMonitor();
        }
        while (true) {
            int num = (int)(Math.random() * (double)tasks.length);
            System.out.println("now scheduling: " + num);
            MyMonitor myMonitor = monitors[num];
            synchronized (myMonitor) {
                monitors[num].setRunning(true);
                if (tasks[num] == null) {
                    tasks[num] = new MyTask("" + num, monitors[num]);
                    tp.execute(tasks[num]);
                } else {
                    monitors[num].notify();
                }
                Thread.yield();
                System.out.println("sleeping scheduler");
                try {
                    monitors[num].wait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (monitors[num].isRunning()) {
                    System.out.println("Thread was interrupted: " + num);
                }
            }
        }
    }

    class MyMonitor {
        protected boolean running = true;

        public boolean isRunning() {
            return this.running;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }
    }

    class MyTask
    implements Runnable {
        protected String name;
        protected MyMonitor monitor;

        public MyTask(String name, MyMonitor monitor) {
            this.name = name;
            this.monitor = monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("first woken up: " + this);
            while (true) {
                try {
                    Thread.sleep(3000L);
                    MyMonitor myMonitor = this.monitor;
                    synchronized (myMonitor) {
                        System.out.println("sleeping: " + this);
                        this.monitor.setRunning(false);
                        this.monitor.notify();
                        this.monitor.wait();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("woken up: " + this);
            }
        }

        public String toString() {
            return this.name;
        }
    }
}

