/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.concurrent;

import jadex.commons.concurrent.IThreadPool;
import java.util.HashMap;
import java.util.Map;

public class ThreadPoolFactory {
    public static final String THREADPOOL_STANDARD = "jadex.commons.concurrent.ThreadPool";
    public static final String THREADPOOL_JAVA5 = "jadex.commons.concurrent.java5.JavaThreadPool";
    protected static final Map threadpools = new HashMap();

    public static synchronized IThreadPool getThreadPool(String name) {
        IThreadPool ret = (IThreadPool)threadpools.get(name);
        if (ret == null) {
            ret = ThreadPoolFactory.createThreadPool();
            threadpools.put(name, ret);
        }
        return ret;
    }

    public static IThreadPool createThreadPool() {
        IThreadPool instance;
        try {
            try {
                instance = (IThreadPool)Class.forName(THREADPOOL_JAVA5).newInstance();
            }
            catch (Exception e) {
                instance = (IThreadPool)Class.forName(THREADPOOL_STANDARD).newInstance();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create thread pool.");
        }
        return instance;
    }
}

