/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.concurrent;

import jadex.commons.ChangeEvent;
import jadex.commons.DefaultPoolStrategy;
import jadex.commons.ErrorException;
import jadex.commons.IChangeListener;
import jadex.commons.IPoolStrategy;
import jadex.commons.SReflect;
import jadex.commons.TimeoutException;
import jadex.commons.collection.ArrayBlockingQueue;
import jadex.commons.collection.IBlockingQueue;
import jadex.commons.concurrent.IThreadPool;
import jadex.commons.future.Future;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class ThreadPool
implements IThreadPool {
    public static final Map<Thread, Future<?>> WAITING_THREADS = Collections.synchronizedMap(new HashMap());
    public static final boolean PROFILING = false;
    public static final long PRINT_DELAY = 10000L;
    protected static Map<Class<?>, Integer> calls = null;
    protected static int threadcnt = 0;
    protected static int poolcnt = 0;
    protected ThreadGroup group;
    protected IPoolStrategy strategy;
    protected List<ServiceThread> pool;
    protected List<ServiceThread> parked;
    protected IBlockingQueue<Runnable> tasks;
    protected volatile boolean running;
    protected boolean daemon;
    protected Map<Runnable, Long> enqueuetimes;
    protected int maxparked;
    protected Timer timer;
    protected long maxwait;
    protected List<IChangeListener<Void>> listeners;
    protected boolean finished;
    static int cnt = 0;
    static int todo;

    public ThreadPool() {
        this((IPoolStrategy)new DefaultPoolStrategy(0, 20, 30000L, 0));
    }

    public ThreadPool(IPoolStrategy strategy) {
        this(false, strategy);
    }

    public ThreadPool(boolean daemon, IPoolStrategy strategy) {
        this(daemon, strategy, 500L);
    }

    public ThreadPool(boolean daemon, final IPoolStrategy strategy, final long maxwait) {
        this.daemon = daemon;
        this.strategy = strategy;
        this.group = new ThreadGroup("strategy_thread_pool_" + poolcnt++);
        this.running = true;
        this.tasks = new ArrayBlockingQueue();
        this.pool = new ArrayList<ServiceThread>();
        this.enqueuetimes = Collections.synchronizedMap(new IdentityHashMap());
        this.maxparked = 500;
        this.parked = new ArrayList<ServiceThread>();
        this.maxwait = maxwait;
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ThreadPool threadPool = ThreadPool.this;
                synchronized (threadPool) {
                    Runnable task;
                    Long start;
                    if (ThreadPool.this.running && ThreadPool.this.tasks.size() > 0 && (start = ThreadPool.this.enqueuetimes.get(task = (Runnable)ThreadPool.this.tasks.peek())) != null && strategy.getCapacity() == 0 && start + maxwait < System.currentTimeMillis()) {
                        ThreadPool.this.addThreads(5);
                        strategy.workersAdded(5);
                    }
                }
            }
        }, maxwait, maxwait);
        this.addThreads(strategy.getWorkerCount());
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public synchronized void execute(Runnable task) {
        if (!this.running) {
            throw new RuntimeException("Thread pool not running: " + this);
        }
        if (this.strategy.taskAdded()) {
            this.addThreads(1);
        }
        if (this.enqueuetimes.put(task, System.currentTimeMillis()) != null) {
            throw new RuntimeException("Task already scheduled: " + task);
        }
        this.tasks.enqueue((Object)task);
    }

    @Override
    public void executeForever(Runnable task) {
        Thread t = new Thread(task);
        t.setDaemon(this.daemon);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void dispose() {
        this.running = false;
        this.tasks.setClosed(true);
        if (this.timer != null) {
            this.timer.cancel();
        }
        ServiceThread[] pots = this.pool.toArray(new ServiceThread[this.pool.size()]);
        ServiceThread[] pts = this.parked.toArray(new ServiceThread[this.parked.size()]);
        if (pots.length == 0 && pts.length == 0) {
            this.notifyFinishListeners();
        } else {
            ServiceThread serviceThread;
            for (ServiceThread thread : pots) {
                if (WAITING_THREADS.containsKey(thread)) {
                    WAITING_THREADS.get(thread).setExceptionIfUndone((Exception)new ErrorException((Error)new ThreadDeath()));
                }
                serviceThread = thread;
                synchronized (serviceThread) {
                    thread.terminated = true;
                    thread.interrupt();
                }
            }
            for (ServiceThread thread : pts) {
                if (WAITING_THREADS.containsKey(thread)) {
                    WAITING_THREADS.get(thread).setExceptionIfUndone((Exception)new ErrorException((Error)new ThreadDeath()));
                }
                serviceThread = thread;
                synchronized (serviceThread) {
                    thread.terminated = true;
                    thread.interrupt();
                }
            }
        }
        this.group = null;
        this.timer = null;
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(SReflect.getInnerClassName(this.getClass()));
        buf.append("(poolsize=");
        buf.append(this.pool.size());
        buf.append(", running=");
        buf.append(this.running);
        buf.append(")");
        return buf.toString() + " " + this.hashCode();
    }

    protected synchronized void addThreads(int num) {
        for (int i = 0; i < num; ++i) {
            this.addThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void addThread() {
        if (!this.parked.isEmpty()) {
            ServiceThread thread;
            ServiceThread serviceThread = thread = this.parked.remove(0);
            synchronized (serviceThread) {
                thread.notified = true;
                thread.notify();
            }
        } else {
            ServiceThread thread = new ServiceThread();
            thread.setDaemon(this.daemon);
            this.pool.add(thread);
            thread.start();
        }
    }

    protected synchronized Runnable getTask(Thread thread) {
        Runnable ret = null;
        if (thread instanceof ServiceThread) {
            ret = ((ServiceThread)thread).getTask();
        }
        return ret;
    }

    @Override
    public synchronized void addFinishListener(IChangeListener<Void> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IChangeListener<Void>>();
        }
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFinishListeners() {
        IChangeListener[] lisar;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            lisar = this.listeners == null ? null : this.listeners.toArray(new IChangeListener[this.listeners.size()]);
        }
        if (lisar != null) {
            ChangeEvent ce = new ChangeEvent(null);
            for (IChangeListener lis : lisar) {
                lis.changeOccurred(ce);
            }
        }
    }

    public static void main(String[] args) {
    }

    class TPTimerTask {
        TPTimerTask() {
        }
    }

    public class ServiceThread
    extends Thread {
        protected Runnable task;
        protected boolean terminated;
        protected boolean notified;

        public ServiceThread() {
            super(ThreadPool.this.group, "ServiceThread_" + ++threadcnt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (ThreadPool.this.running && !this.terminated) {
                boolean park;
                boolean exit = false;
                try {
                    this.task = (Runnable)ThreadPool.this.tasks.dequeue(ThreadPool.this.strategy.getWorkerTimeout());
                    Long start = ThreadPool.this.enqueuetimes.remove(this.task);
                    long now = System.currentTimeMillis();
                    ThreadPool.this.strategy.taskServed(now - start);
                    try {
                        if (this.task != null) {
                            this.task.run();
                        }
                    }
                    catch (ThreadDeath threadDeath) {}
                }
                catch (IBlockingQueue.ClosedException e) {
                    assert (this.task == null);
                    exit = true;
                }
                catch (TimeoutException e) {
                    assert (this.task == null);
                    exit = ThreadPool.this.strategy.workerTimeoutOccurred();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.task != null) {
                    this.task = null;
                    exit = ThreadPool.this.strategy.taskFinished();
                }
                if (!exit) continue;
                Object object = ThreadPool.this;
                synchronized (object) {
                    park = ThreadPool.this.running && ThreadPool.this.parked.size() < ThreadPool.this.maxparked;
                }
                if (park) {
                    this.markParked();
                    object = this;
                    synchronized (object) {
                        if (ThreadPool.this.running) {
                            try {
                                this.wait(ThreadPool.this.strategy.getWorkerTimeout());
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (this.notified) {
                        this.notified = false;
                        this.markUnpark();
                        continue;
                    }
                    this.terminated = true;
                    continue;
                }
                this.terminated = true;
            }
            this.remove();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void markParked() {
            ThreadPool threadPool = ThreadPool.this;
            synchronized (threadPool) {
                ThreadPool.this.pool.remove(this);
                ThreadPool.this.parked.add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void markUnpark() {
            ThreadPool threadPool = ThreadPool.this;
            synchronized (threadPool) {
                ThreadPool.this.pool.add(this);
                ThreadPool.this.parked.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void remove() {
            this.terminated = true;
            boolean notify = false;
            ThreadPool threadPool = ThreadPool.this;
            synchronized (threadPool) {
                ThreadPool.this.pool.remove(this);
                ThreadPool.this.parked.remove(this);
                if (!ThreadPool.this.finished && ThreadPool.this.pool.size() == 0 && ThreadPool.this.parked.size() == 0) {
                    ThreadPool.this.finished = true;
                    notify = true;
                }
            }
            if (notify) {
                ThreadPool.this.notifyFinishListeners();
            }
        }

        public Runnable getTask() {
            return this.task;
        }

        @Override
        public String toString() {
            return super.toString() + ":" + this.hashCode() + ", task=" + this.task;
        }
    }
}

