/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.concurrent;

import jadex.commons.collection.BlockingQueue;
import jadex.commons.collection.IBlockingQueue;

public class MultiThreadTest {
    protected static IBlockingQueue<ExecutionThread> waits;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int i;
        waits = new BlockingQueue();
        Thread[] threads = new Thread[3];
        MyMonitor[] monitors = new MyMonitor[threads.length];
        for (i = 0; i < monitors.length; ++i) {
            monitors[i] = new MyMonitor();
        }
        for (i = 0; i < threads.length; ++i) {
            System.out.println("now starting: " + i);
            monitors[i].setRunning(true);
            if (threads[i] == null) {
                threads[i] = new ExecutionThread("" + i, monitors[i]);
                threads[i].start();
                continue;
            }
            MyMonitor myMonitor = monitors[i];
            synchronized (myMonitor) {
                monitors[i].notify();
                continue;
            }
        }
        while (true) {
            ExecutionThread et = (ExecutionThread)waits.dequeue();
            MyMonitor monitor = et.getMonitor();
            System.out.println("Restarting: " + et);
            MyMonitor myMonitor = monitor;
            synchronized (myMonitor) {
                monitor.setRunning(true);
                et.getMonitor().notify();
            }
        }
    }

    static class MyMonitor {
        protected boolean running = false;

        public boolean isRunning() {
            return this.running;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }
    }

    static class ExecutionThread
    extends Thread {
        protected MyMonitor monitor;

        public ExecutionThread(String name, MyMonitor monitor) {
            super(name);
            this.monitor = monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("a: (some work)" + this);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("b: (pause): " + this);
            MyMonitor myMonitor = this.monitor;
            synchronized (myMonitor) {
                this.monitor.setRunning(false);
                try {
                    waits.enqueue((Object)this);
                    this.monitor.wait();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.out.println("c: (some other work)" + this);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("finished: " + this);
        }

        protected MyMonitor getMonitor() {
            return this.monitor;
        }
    }
}

