/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.concurrent;

import jadex.commons.SUtil;
import jadex.commons.concurrent.MonitoredThread;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class MonitoredThreadPoolExecutor
extends ThreadPoolExecutor {
    protected static final boolean DEBUG = false;
    protected static final boolean AGGRESSIVE = true;
    protected static final int MONIT_THRESHOLD = Runtime.getRuntime().availableProcessors();
    protected static final int BASE_TCNT = (MONIT_THRESHOLD << 1) + 2;
    protected static final long MONIT_CYCLE = 500L;
    protected static final long LOSS_THRESHOLD = 1000L;
    protected static final long LOSS_THRESHOLD_BUSY = 10000L;
    protected AtomicInteger idle;
    protected volatile MonitoredThread[] threads;
    protected volatile Semaphore monitoringlock = new Semaphore(0);
    protected Thread monitthread;
    protected boolean monitoring = true;

    public MonitoredThreadPoolExecutor() {
        super(BASE_TCNT, BASE_TCNT, Long.MAX_VALUE, TimeUnit.NANOSECONDS, new LinkedBlockingQueue<Runnable>());
        this.idle = new AtomicInteger(BASE_TCNT);
        this.threads = new MonitoredThread[BASE_TCNT];
        this.setThreadFactory(new ThreadFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Thread newThread(final Runnable r) {
                Runnable innerr = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        r.run();
                        MonitoredThreadPoolExecutor monitoredThreadPoolExecutor = MonitoredThreadPoolExecutor.this;
                        synchronized (monitoredThreadPoolExecutor) {
                            int i = MonitoredThreadPoolExecutor.currentThread().getNumber();
                            if (i < MonitoredThreadPoolExecutor.this.threads.length) {
                                MonitoredThreadPoolExecutor.this.threads[i] = null;
                            }
                        }
                    }
                };
                MonitoredThread t = new MonitoredThread(innerr, MonitoredThreadPoolExecutor.this);
                t.setDaemon(true);
                MonitoredThreadPoolExecutor monitoredThreadPoolExecutor = MonitoredThreadPoolExecutor.this;
                synchronized (monitoredThreadPoolExecutor) {
                    for (int i = 0; i < MonitoredThreadPoolExecutor.this.threads.length; ++i) {
                        if (MonitoredThreadPoolExecutor.this.threads[i] != null) continue;
                        t.setNumber(i);
                        MonitoredThreadPoolExecutor.this.threads[i] = t;
                        break;
                    }
                }
                return t;
            }
        });
        this.monitthread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (MonitoredThreadPoolExecutor.this.monitoring) {
                    LockSupport.parkUntil(System.currentTimeMillis() + 500L);
                    try {
                        Semaphore mlock = MonitoredThreadPoolExecutor.this.monitoringlock;
                        if (mlock != null) {
                            mlock.acquire();
                        }
                        int n = MonitoredThreadPoolExecutor.this.monitoringlock.drainPermits();
                    }
                    catch (Exception mlock) {
                        // empty catch block
                    }
                    int borrowed = 0;
                    long thres = 1000L;
                    long thresbusy = 10000L;
                    thres >>>= Math.max(MonitoredThreadPoolExecutor.this.getQueue().size() / MONIT_THRESHOLD - 1, 0);
                    thres = System.currentTimeMillis() - thres;
                    thresbusy = System.currentTimeMillis() - thresbusy;
                    for (int i = 0; i < MonitoredThreadPoolExecutor.this.threads.length; ++i) {
                        MonitoredThread thread = MonitoredThreadPoolExecutor.this.threads[i];
                        if (thread == null) continue;
                        if (!thread.isBorrowed() && (thread.getDeparture() < thres && thread.isBlocked() || thread.getDeparture() < thresbusy)) {
                            MonitoredThreadPoolExecutor.this.borrowNoUnpark(thread);
                        }
                        if (thread.isBorrowed()) {
                            ++borrowed;
                        }
                        if (thread.getDeparture() == Long.MAX_VALUE) continue;
                        SUtil.getStackTraceString((String)"", (StackTraceElement[])thread.getStackTrace());
                    }
                    int adjustment = -(MonitoredThreadPoolExecutor.this.getMaximumPoolSize() - BASE_TCNT - borrowed);
                    if (adjustment == 0) continue;
                    int newsize = MonitoredThreadPoolExecutor.this.getMaximumPoolSize() + adjustment;
                    if (newsize > MonitoredThreadPoolExecutor.this.threads.length) {
                        MonitoredThreadPoolExecutor monitoredThreadPoolExecutor = MonitoredThreadPoolExecutor.this;
                        synchronized (monitoredThreadPoolExecutor) {
                            MonitoredThread[] newthreads = new MonitoredThread[newsize];
                            System.arraycopy(MonitoredThreadPoolExecutor.this.threads, 0, newthreads, 0, MonitoredThreadPoolExecutor.this.threads.length);
                            MonitoredThreadPoolExecutor.this.threads = newthreads;
                        }
                    }
                    if (MonitoredThreadPoolExecutor.this.idle.addAndGet(adjustment) > MONIT_THRESHOLD) {
                        MonitoredThreadPoolExecutor.this.monitoringlock = new Semaphore(1);
                    }
                    if (adjustment < 0) {
                        MonitoredThreadPoolExecutor.this.setCorePoolSize(newsize);
                        MonitoredThreadPoolExecutor.this.setMaximumPoolSize(newsize);
                        continue;
                    }
                    MonitoredThreadPoolExecutor.this.setMaximumPoolSize(newsize);
                    MonitoredThreadPoolExecutor.this.setCorePoolSize(newsize);
                    MonitoredThreadPoolExecutor.this.prestartAllCoreThreads();
                }
            }
        });
        this.monitthread.setDaemon(true);
        this.monitthread.start();
        this.prestartAllCoreThreads();
    }

    @Override
    public void execute(final Runnable command) {
        super.execute(new Runnable(){

            @Override
            public void run() {
                MonitoredThreadPoolExecutor.currentThread().setDeparture(System.currentTimeMillis());
                if (MonitoredThreadPoolExecutor.this.idle.decrementAndGet() < MONIT_THRESHOLD) {
                    Semaphore mlock = MonitoredThreadPoolExecutor.this.monitoringlock;
                    MonitoredThreadPoolExecutor.this.monitoringlock = null;
                    MonitoredThreadPoolExecutor.releaseLock(mlock);
                }
                command.run();
                MonitoredThreadPoolExecutor.currentThread().setDeparture(Long.MAX_VALUE);
                if (MonitoredThreadPoolExecutor.currentThread().isBorrowed()) {
                    MonitoredThreadPoolExecutor.currentThread().borrowed = false;
                    MonitoredThreadPoolExecutor.releaseLock(MonitoredThreadPoolExecutor.this.monitoringlock);
                }
                if (MonitoredThreadPoolExecutor.this.idle.incrementAndGet() > MONIT_THRESHOLD && MonitoredThreadPoolExecutor.this.monitoringlock == null) {
                    MonitoredThreadPoolExecutor.this.monitoringlock = new Semaphore(1);
                }
            }
        });
    }

    protected void borrow(MonitoredThread thread) {
        this.borrowNoUnpark(thread);
        LockSupport.unpark(this.monitthread);
    }

    protected void borrowNoUnpark(MonitoredThread thread) {
        thread.borrowed = true;
        MonitoredThreadPoolExecutor.releaseLock(this.monitoringlock);
    }

    protected static final void releaseLock(Semaphore lock) {
        if (lock != null) {
            lock.release();
        }
    }

    protected static final MonitoredThread currentThread() {
        return (MonitoredThread)Thread.currentThread();
    }
}

