/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.concurrent;

import jadex.commons.concurrent.Executor;
import jadex.commons.concurrent.IExecutable;
import jadex.commons.concurrent.IThreadPool;
import jadex.commons.concurrent.ThreadPoolFactory;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class LoadManagingExecutionService {
    protected IThreadPool pool;
    protected double load;
    protected long timeslice;
    protected Set tasks;
    protected Executor executor;
    protected int limit;
    protected long start;
    protected int concurrency;
    protected static int COUNTER = 0;

    public LoadManagingExecutionService(IThreadPool pool) {
        this(pool, 50L);
    }

    public LoadManagingExecutionService(IThreadPool threadpool, long timeslice) {
        this.pool = threadpool;
        this.timeslice = timeslice;
        this.limit = 1;
        this.tasks = new TreeSet();
        this.executor = new Executor(this.pool, new IExecutable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean execute() {
                try {
                    try {
                        Thread.sleep((long)((double)LoadManagingExecutionService.this.timeslice * (1.0 - LoadManagingExecutionService.this.load)));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LoadManagingExecutionService loadManagingExecutionService = LoadManagingExecutionService.this;
                    synchronized (loadManagingExecutionService) {
                        if (LoadManagingExecutionService.this.concurrency != 0) {
                            return false;
                        }
                        LoadManagingExecutionService.this.start = System.nanoTime();
                        LoadManagingExecutionService.this.concurrency = 0;
                        LoadManagingExecutionService.this.load = 0.0;
                        Iterator it = LoadManagingExecutionService.this.tasks.iterator();
                        while (LoadManagingExecutionService.this.concurrency < LoadManagingExecutionService.this.limit && it.hasNext()) {
                            Task task = (Task)it.next();
                            if (LoadManagingExecutionService.this.load == 0.0) {
                                LoadManagingExecutionService.this.load = task.priority;
                            }
                            if (LoadManagingExecutionService.this.load != task.priority) break;
                            it.remove();
                            ++LoadManagingExecutionService.this.concurrency;
                            LoadManagingExecutionService.this.pool.execute(task);
                        }
                        if (LoadManagingExecutionService.this.concurrency > 0) {
                            LoadManagingExecutionService.this.limit = LoadManagingExecutionService.this.concurrency;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        });
    }

    public synchronized void execute(IExecutable executable, double priority) {
        this.tasks.add(new Task(executable, priority));
        if (this.concurrency == 0) {
            try {
                this.executor.execute();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected synchronized void taskPerformed(Task task) {
        --this.concurrency;
        if (this.concurrency == 0) {
            long time = System.nanoTime() - this.start;
            double newlimit = (double)this.limit * ((double)this.timeslice * this.load * 1000000.0) / (double)time;
            this.limit = Math.max(1, this.limit + (int)(0.5 * (newlimit - (double)this.limit)));
            if (!this.tasks.isEmpty()) {
                try {
                    this.executor.execute();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void main(String[] args) {
        double PRIORITY = 0.1;
        LoadManagingExecutionService service = new LoadManagingExecutionService(ThreadPoolFactory.createThreadPool());
        service.execute(new TestExecutable(), PRIORITY);
        service.execute(new TestExecutable(), PRIORITY);
        service.execute(new TestExecutable(), PRIORITY);
        service.execute(new TestExecutable(), PRIORITY + 0.3);
        service.execute(new TestExecutable(), PRIORITY + 0.3);
        service.execute(new TestExecutable(), PRIORITY + 0.3);
        service.execute(new TestExecutable(), PRIORITY + 0.8);
        service.execute(new TestExecutable(), PRIORITY + 0.8);
    }

    static class TestExecutable
    implements IExecutable {
        int cnt = 1;

        TestExecutable() {
        }

        @Override
        public boolean execute() {
            double sum = 0.0;
            for (int i = 0; i < 5000000; ++i) {
                sum += (double)i;
            }
            System.out.println("Executed " + this + ", " + this.cnt);
            return this.cnt++ < 10;
        }
    }

    public class Task
    implements Runnable,
    Comparable {
        protected IExecutable executable;
        protected double priority;
        protected int seqnr;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Task(IExecutable task, double priority) {
            this.executable = task;
            this.priority = priority;
            Class<Task> clazz = Task.class;
            synchronized (Task.class) {
                this.seqnr = COUNTER++;
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean execute = false;
            try {
                execute = this.executable.execute();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            LoadManagingExecutionService loadManagingExecutionService = LoadManagingExecutionService.this;
            synchronized (loadManagingExecutionService) {
                if (execute) {
                    LoadManagingExecutionService.this.execute(this.executable, this.priority);
                }
                LoadManagingExecutionService.this.taskPerformed(this);
            }
        }

        public int compareTo(Object obj) {
            double ret = -1.0;
            if (obj instanceof Task) {
                ret = this.priority != ((Task)obj).priority ? ((Task)obj).priority - this.priority : (double)(this.seqnr - ((Task)obj).seqnr);
            }
            return ret > 0.0 ? 1 : (ret < 0.0 ? -1 : 0);
        }

        public String toString() {
            return "Task(" + this.executable + ", seqnr=" + this.seqnr + ", priority=" + this.priority + ")";
        }
    }
}

