/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.concurrent;

import jadex.commons.ChangeEvent;
import jadex.commons.IChangeListener;
import jadex.commons.concurrent.IThreadPool;
import jadex.commons.future.Future;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class JavaThreadPool
implements IThreadPool {
    protected ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(final Runnable r) {
            Thread ret = new Thread(r){

                @Override
                public String toString() {
                    return super.toString() + ":" + this.hashCode() + ", task=" + r;
                }
            };
            ret.setDaemon(true);
            return ret;
        }
    });
    protected List<IChangeListener<Void>> listeners;
    protected Future<Void> shutdown = new Future();

    public JavaThreadPool(boolean daemon) {
        Thread shutdownthread = new Thread(new Runnable(){

            @Override
            public void run() {
                JavaThreadPool.this.shutdown.get();
                JavaThreadPool.this.executor.shutdown();
                try {
                    JavaThreadPool.this.executor.awaitTermination(10000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JavaThreadPool.this.notifyFinishListeners();
            }
        });
        shutdownthread.setDaemon(daemon);
        shutdownthread.start();
    }

    @Override
    public void execute(Runnable task) {
        this.executor.execute(task);
    }

    @Override
    public void executeForever(Runnable task) {
        Thread t = new Thread(task);
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void dispose() {
        this.shutdown.setResultIfUndone(null);
    }

    @Override
    public boolean isRunning() {
        return !this.executor.isShutdown();
    }

    @Override
    public synchronized void addFinishListener(IChangeListener<Void> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IChangeListener<Void>>();
        }
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFinishListeners() {
        IChangeListener[] lisar;
        JavaThreadPool javaThreadPool = this;
        synchronized (javaThreadPool) {
            lisar = this.listeners == null ? null : this.listeners.toArray(new IChangeListener[this.listeners.size()]);
        }
        if (lisar != null) {
            ChangeEvent ce = new ChangeEvent(null);
            for (IChangeListener lis : lisar) {
                lis.changeOccurred(ce);
            }
        }
    }
}

