/*
 * Decompiled with CFR 0.152.
 */
package jadex.commons.concurrent;

import jadex.commons.SUtil;
import jadex.commons.concurrent.IExecutable;
import jadex.commons.concurrent.IThreadPool;
import jadex.commons.concurrent.MonitoredThread;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Executor
implements Runnable {
    public static final ThreadLocal<Executor> EXECUTOR = new ThreadLocal();
    protected boolean running;
    protected boolean wanttorun;
    private boolean shutdown;
    private boolean shutdowned;
    protected IThreadPool threadpool;
    protected IExecutable executable;
    protected List<Future<Void>> shutdownfutures;
    protected Object monitor;
    protected int exethreadcnt;
    protected List<Object> switchtos;
    protected Map<Object, Throwable> throwables;

    public Executor(IThreadPool threadpool) {
        this(threadpool, null);
    }

    public Executor(IThreadPool threadpool, IExecutable executable) {
        if (threadpool == null) {
            throw new IllegalArgumentException("Threadpool must not null.");
        }
        this.threadpool = threadpool;
        this.executable = executable;
        this.shutdownfutures = new ArrayList<Future<Void>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this;
        synchronized (object) {
            ++this.exethreadcnt;
        }
        if (this.monitor != null) {
            object = this.monitor;
            synchronized (object) {
            }
        }
        EXECUTOR.set(this);
        boolean iwanttorun = true;
        Object switchto = null;
        while (iwanttorun && !this.shutdown) {
            try {
                iwanttorun = this.code();
            }
            catch (ThreadDeath e) {
                iwanttorun = false;
            }
            catch (Throwable e) {
                System.err.println("Exception in executable " + this.executable + ": " + SUtil.getExceptionStacktrace((Throwable)e));
                iwanttorun = false;
            }
            Executor e = this;
            synchronized (e) {
                if (this.switchtos != null && this.switchtos.size() > 0) {
                    switchto = this.switchtos.remove(0);
                }
            }
            if (switchto == null) {
                e = this;
                synchronized (e) {
                    this.running = iwanttorun = iwanttorun || this.wanttorun;
                    this.wanttorun = false;
                    continue;
                }
            }
            iwanttorun = false;
        }
        ArrayList<Future<Void>> futures = null;
        Executor executor = this;
        synchronized (executor) {
            if (this.shutdown && !this.shutdowned && (this.switchtos == null || this.switchtos.isEmpty())) {
                futures = new ArrayList<Future<Void>>(this.shutdownfutures);
                this.shutdownfutures.clear();
                this.shutdowned = true;
            }
            if (switchto == null && this.switchtos != null && this.switchtos.size() > 0) {
                switchto = this.switchtos.remove(0);
            }
        }
        if (futures != null) {
            for (int i = 0; i < futures.size(); ++i) {
                ((Future)futures.get(i)).setResult(null);
            }
        }
        EXECUTOR.set(null);
        Object object2 = this;
        synchronized (object2) {
            --this.exethreadcnt;
        }
        if (switchto != null) {
            object2 = switchto;
            synchronized (object2) {
                switchto.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        boolean execute = false;
        Executor executor = this;
        synchronized (executor) {
            if (!this.shutdown) {
                if (this.running) {
                    this.wanttorun = true;
                } else {
                    this.running = true;
                    execute = true;
                }
            }
        }
        if (execute) {
            this.threadpool.execute(this);
        }
        return execute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture<Void> shutdown() {
        Future<Void> ret = new Future<Void>();
        boolean directnotify = false;
        Executor executor = this;
        synchronized (executor) {
            if (!this.shutdowned) {
                this.shutdownfutures.add(ret);
                this.execute();
            } else {
                directnotify = true;
            }
            this.shutdown = true;
        }
        if (directnotify) {
            ret.setResult(null);
        }
        return ret;
    }

    public void setExecutable(IExecutable executable) {
        this.executable = executable;
    }

    protected boolean code() {
        return this.executable.execute();
    }

    protected boolean isRunning() {
        return this.running;
    }

    protected int getThreadCount() {
        return this.exethreadcnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchThread(Object monitor, Throwable t) {
        Executor executor = this;
        synchronized (executor) {
            if (this.switchtos == null) {
                this.switchtos = new LinkedList<Object>();
            }
            this.switchtos.add(monitor);
            if (t != null) {
                if (this.throwables == null) {
                    this.throwables = new HashMap<Object, Throwable>();
                }
                this.throwables.put(monitor, t);
            }
        }
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockThread(Object monitor) {
        Object object = monitor;
        synchronized (object) {
            Throwable t;
            this.running = false;
            this.monitor = monitor;
            this.execute();
            MonitoredThread.tryBorrow();
            try {
                monitor.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.running = true;
            }
            if (this.throwables != null && (t = this.throwables.remove(monitor)) != null) {
                Future.throwException(t);
            }
        }
    }

    public String toString() {
        return "Executor(" + this.executable + ")";
    }

    public boolean isSwitching() {
        return this.switchtos != null && !this.switchtos.isEmpty();
    }
}

