/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost;

import java.util.HashMap;
import java.util.Map;
import oauth.signpost.OAuth;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.exception.OAuthNotAuthorizedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOAuthProvider
implements OAuthProvider {
    private static final long serialVersionUID = 1L;
    private String requestTokenEndpointUrl;
    private String accessTokenEndpointUrl;
    private String authorizationWebsiteUrl;
    private Map<String, String> responseParameters;
    private Map<String, String> defaultHeaders;
    private boolean isOAuth10a;

    public AbstractOAuthProvider(String requestTokenEndpointUrl, String accessTokenEndpointUrl, String authorizationWebsiteUrl) {
        this.requestTokenEndpointUrl = requestTokenEndpointUrl;
        this.accessTokenEndpointUrl = accessTokenEndpointUrl;
        this.authorizationWebsiteUrl = authorizationWebsiteUrl;
        this.responseParameters = new HashMap<String, String>();
        this.defaultHeaders = new HashMap<String, String>();
    }

    @Override
    public String retrieveRequestToken(OAuthConsumer consumer, String callbackUrl) throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException {
        consumer.setTokenWithSecret(null, null);
        this.retrieveToken(consumer, OAuth.addQueryParameters(this.requestTokenEndpointUrl, "oauth_callback", callbackUrl));
        String callbackConfirmed = this.responseParameters.get("oauth_callback_confirmed");
        this.responseParameters.remove("oauth_callback_confirmed");
        this.isOAuth10a = Boolean.TRUE.toString().equals(callbackConfirmed);
        if (this.isOAuth10a) {
            return OAuth.addQueryParameters(this.authorizationWebsiteUrl, "oauth_token", consumer.getToken());
        }
        return OAuth.addQueryParameters(this.authorizationWebsiteUrl, "oauth_token", consumer.getToken(), "oauth_callback", callbackUrl);
    }

    @Override
    public void retrieveAccessToken(OAuthConsumer consumer, String oauthVerifier) throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException {
        if (consumer.getToken() == null || consumer.getTokenSecret() == null) {
            throw new OAuthExpectationFailedException("Authorized request token or token secret not set. Did you retrieve an authorized request token before?");
        }
        String endpointUrl = this.isOAuth10a && oauthVerifier != null ? OAuth.addQueryParameters(this.accessTokenEndpointUrl, "oauth_verifier", oauthVerifier) : this.accessTokenEndpointUrl;
        this.retrieveToken(consumer, endpointUrl);
    }

    protected abstract void retrieveToken(OAuthConsumer var1, String var2) throws OAuthMessageSignerException, OAuthCommunicationException, OAuthNotAuthorizedException, OAuthExpectationFailedException;

    @Override
    public Map<String, String> getResponseParameters() {
        return this.responseParameters;
    }

    protected String getResponseParameter(String key) {
        return this.responseParameters.get(key);
    }

    @Override
    public void setResponseParameters(Map<String, String> parameters) {
        this.responseParameters = parameters;
    }

    @Override
    public void setOAuth10a(boolean isOAuth10aProvider) {
        this.isOAuth10a = isOAuth10aProvider;
    }

    @Override
    public boolean isOAuth10a() {
        return this.isOAuth10a;
    }

    @Override
    public String getRequestTokenEndpointUrl() {
        return this.requestTokenEndpointUrl;
    }

    @Override
    public String getAccessTokenEndpointUrl() {
        return this.accessTokenEndpointUrl;
    }

    @Override
    public String getAuthorizationWebsiteUrl() {
        return this.authorizationWebsiteUrl;
    }

    @Override
    public void setRequestHeader(String header, String value) {
        this.defaultHeaders.put(header, value);
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.defaultHeaders;
    }
}

