/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import weka.core.EnumHelper;
import weka.core.Environment;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Utils;
import weka.core.WekaException;
import weka.knowledgeflow.JobEnvironment;
import weka.knowledgeflow.StepManager;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.Step;
import weka.knowledgeflow.steps.WekaAlgorithmWrapper;

@KFStep(name="SetPropertiesFromEnvironment", category="Flow", toolTipText="Set properties of the connected algorithm-based step (e.g. Classifier, Clusterer etc.) using values stored in the flow environment. If no property path for a particular setting value is specified, then it is assumed that the value provided is scheme name + options in command-line form, in which case the underlying scheme of the connected step will be constructed and set; otherwise, the property path is used to set a value on the existing underlying scheme.", iconPath="weka/gui/knowledgeflow/icons/SetPropertiesFromEnvironment.gif")
public class SetPropertiesFromEnvironment
extends BaseStep {
    private static final long serialVersionUID = -8316084792512232973L;

    @Override
    public void stepInit() throws WekaException {
        Environment env = this.getStepManager().getExecutionEnvironment().getEnvironmentVariables();
        if (env instanceof JobEnvironment && this.getStepManager().numOutgoingConnections() == 1) {
            Step connectedStep;
            String stepName;
            Map<String, String> propertiesToSet;
            Map<String, List<StepManager>> outgoing = this.getStepManager().getOutgoingConnections();
            StepManagerImpl connectedManager = null;
            for (Map.Entry<String, List<StepManager>> e : outgoing.entrySet()) {
                connectedManager = (StepManagerImpl)e.getValue().get(0);
            }
            if (connectedManager != null && (propertiesToSet = ((JobEnvironment)env).getStepProperties(stepName = (connectedStep = connectedManager.getManagedStep()).getName())) != null && propertiesToSet.size() > 0 && connectedStep instanceof WekaAlgorithmWrapper) {
                this.setProperties((WekaAlgorithmWrapper)connectedStep, propertiesToSet);
            }
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return null;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        if (this.getStepManager().numOutgoingConnections() == 0) {
            return Arrays.asList("info");
        }
        return null;
    }

    protected void setProperties(WekaAlgorithmWrapper target, Map<String, String> propertiesToSet) {
        for (Map.Entry<String, String> e : propertiesToSet.entrySet()) {
            String propName = e.getKey();
            String propVal = e.getValue().trim();
            if (propVal.length() == 0) continue;
            try {
                if (propName.length() == 0) {
                    String[] schemeAndOpts = Utils.splitOptions(propVal);
                    if (schemeAndOpts.length <= 0) continue;
                    String schemeName = schemeAndOpts[0];
                    schemeAndOpts[0] = "";
                    Object valToSet = Utils.forName(null, schemeName, schemeAndOpts);
                    this.setValue(target, target.getName(), "wrappedAlgorithm", valToSet);
                    continue;
                }
                String[] propPath = propName.split("\\.");
                Object propRoot = target.getWrappedAlgorithm();
                String propToSet = propPath[propPath.length - 1];
                ArrayList<String> remainingPath = new ArrayList<String>();
                for (int i = 0; i < propPath.length - 1; ++i) {
                    remainingPath.add(propPath[i]);
                }
                if (remainingPath.size() > 0) {
                    propRoot = this.drillToProperty(propRoot, remainingPath);
                }
                Object valToSet = this.stringToVal(propVal, propRoot, propToSet);
                this.setValue(propRoot, propRoot.getClass().getCanonicalName(), propToSet, valToSet);
            }
            catch (Exception ex) {
                String pN = propName.length() == 0 ? "wrapped algorithm" : propName;
                this.getStepManager().logWarning("Unable to set " + pN + " with value: " + propVal + " on step " + target.getName() + ". Reason: " + ex.getMessage());
            }
        }
        try {
            target.stepInit();
        }
        catch (WekaException e) {
            this.getStepManager().logWarning("Was unable to re-initialize step '" + target.getName() + "' after setting properties");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Object stringToVal(String propVal, Object target, String propName) throws WekaException {
        resultVal = null;
        try {
            block29: {
                block28: {
                    prop = this.getPropDescriptor(target, propName);
                    if (prop == null) {
                        throw new WekaException("Unable to find method '" + propName + "'");
                    }
                    getMethod = prop.getReadMethod();
                    current = getMethod.invoke(target, new Object[0]);
                    if (!current.getClass().isArray()) break block28;
                    resultVal = Utils.forName(null, propVal, null);
                    break block29;
                }
                if (!(current instanceof SelectedTag)) ** GOTO lbl32
                legalTags = ((SelectedTag)current).getTags();
                tagIndex = 0x7FFFFFFF;
                try {
                    specifiedID = Integer.parseInt(propVal);
                    for (z = 0; z < legalTags.length; ++z) {
                        if (legalTags[z].getID() != specifiedID) continue;
                        tagIndex = z;
                        break;
                    }
                }
                catch (NumberFormatException e) {
                    for (z = 0; z < legalTags.length; ++z) {
                        if (!legalTags[z].getReadable().equals(propVal.trim())) continue;
                        tagIndex = z;
                        break;
                    }
                }
                if (tagIndex != 0x7FFFFFFF) {
                    resultVal = new SelectedTag(tagIndex, legalTags);
                } else {
                    throw new WekaException("Unable to set SelectedTag value for property '" + propName + "'");
lbl32:
                    // 1 sources

                    if (current instanceof Enum) {
                        helper = new EnumHelper((Enum)current);
                        resultVal = EnumHelper.valueFromString(helper.getEnumClass(), propVal);
                    } else if (current instanceof OptionHandler) {
                        schemeAndOpts = Utils.splitOptions(propVal);
                        if (schemeAndOpts.length > 0) {
                            schemeName = schemeAndOpts[0];
                            schemeAndOpts[0] = "";
                            resultVal = Utils.forName(null, schemeName, schemeAndOpts);
                        }
                    } else if (current instanceof Number) {
                        try {
                            if (current instanceof Integer) {
                                resultVal = new Integer(propVal);
                            }
                            if (current instanceof Long) {
                                resultVal = new Long(propVal);
                            }
                            if (current instanceof Double) {
                                resultVal = new Double(propVal);
                            }
                            if (!(current instanceof Float)) ** GOTO lbl67
                            resultVal = new Float(propVal);
                        }
                        catch (NumberFormatException ex) {
                            throw new WekaException("Unable to parse '" + propVal + "' as a number");
                        }
                    } else if (current instanceof Boolean) {
                        resultVal = propVal.equalsIgnoreCase("true") != false || propVal.equalsIgnoreCase("yes") != false || propVal.equalsIgnoreCase("Y") != false;
                    } else if (current instanceof String) {
                        resultVal = propVal;
                    } else if (current instanceof File) {
                        resultVal = new File(propVal);
                    }
                }
            }
            if (resultVal == null) {
                throw new WekaException("Was unable to determine the value to set for property '" + propName + "'");
            }
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
        return resultVal;
    }

    protected void setValue(Object target, String targetName, String propName, Object valToSet) throws WekaException {
        try {
            this.getStepManager().logDebug("Attempting to set property '" + propName + "' with value of type '" + valToSet.getClass().getCanonicalName() + " '(" + valToSet + ") on '" + targetName + "'");
            PropertyDescriptor prop = this.getPropDescriptor(target, propName);
            if (prop == null) {
                throw new WekaException("Unable to find method '" + propName + "'");
            }
            Method setMethod = prop.getWriteMethod();
            setMethod.invoke(target, valToSet);
        }
        catch (Exception e) {
            throw new WekaException(e);
        }
    }

    protected PropertyDescriptor getPropDescriptor(Object target, String propName) throws IntrospectionException {
        PropertyDescriptor[] properties;
        PropertyDescriptor result = null;
        BeanInfo bi = Introspector.getBeanInfo(target.getClass());
        for (PropertyDescriptor p : properties = bi.getPropertyDescriptors()) {
            if (!p.getName().equals(propName)) continue;
            result = p;
            break;
        }
        return result;
    }

    protected Object drillToProperty(Object baseObject, List<String> propertyPath) throws WekaException {
        Object objectBeingConfigured = baseObject;
        if (propertyPath != null) {
            for (String methodName : propertyPath) {
                try {
                    boolean isArray = methodName.endsWith("]");
                    int arrayIndex = -1;
                    if (isArray) {
                        String arrayPart = methodName.substring(methodName.indexOf(91) + 1, methodName.lastIndexOf(93));
                        arrayIndex = Integer.parseInt(arrayPart.trim());
                        methodName = methodName.substring(0, methodName.indexOf(91));
                    }
                    BeanInfo bi = Introspector.getBeanInfo(objectBeingConfigured.getClass());
                    PropertyDescriptor[] properties = bi.getPropertyDescriptors();
                    PropertyDescriptor targetProperty = null;
                    for (PropertyDescriptor p : properties) {
                        if (!p.getName().equals(methodName)) continue;
                        targetProperty = p;
                        break;
                    }
                    if (targetProperty == null) {
                        throw new WekaException("Unable to find accessor method for property path part: " + methodName + " on object " + objectBeingConfigured.getClass().getName());
                    }
                    Method getMethod = targetProperty.getReadMethod();
                    Object[] args = new Object[]{};
                    objectBeingConfigured = getMethod.invoke(objectBeingConfigured, args);
                    if (!isArray) continue;
                    if (!objectBeingConfigured.getClass().isArray()) {
                        throw new WekaException("Property path element '" + methodName + "' was specified as an array type, but the resulting object retrieved from this property is not an array!");
                    }
                    objectBeingConfigured = ((Object[])objectBeingConfigured)[arrayIndex];
                }
                catch (IntrospectionException ex) {
                    throw new WekaException("GOEManager: couldn't introspect", ex);
                }
                catch (InvocationTargetException e) {
                    throw new WekaException("Invocation target exception when invoking " + methodName + " on " + objectBeingConfigured.getClass().getName(), e);
                }
                catch (IllegalAccessException e) {
                    throw new WekaException(e);
                }
            }
        }
        return objectBeingConfigured;
    }
}

