/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.Instances;
import weka.core.NormalizableDistance;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

public class ManhattanDistance
extends NormalizableDistance
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 6783782554224000243L;

    public ManhattanDistance() {
    }

    public ManhattanDistance(Instances data) {
        super(data);
    }

    @Override
    public String globalInfo() {
        return "Implements the Manhattan distance (or Taxicab geometry). The distance between two points is the sum of the (absolute) differences of their coordinates.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Wikipedia");
        result.setValue(TechnicalInformation.Field.TITLE, "Taxicab geometry");
        result.setValue(TechnicalInformation.Field.URL, "http://en.wikipedia.org/wiki/Taxicab_geometry");
        return result;
    }

    @Override
    protected double updateDistance(double currDist, double diff) {
        double result = currDist;
        return result += Math.abs(diff);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

