/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.RemoveType;

public class RemoveTypeTest
extends AbstractFilterTest {
    public RemoveTypeTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return new RemoveType();
    }

    public Filter getFilter(int attType) {
        RemoveType af = new RemoveType();
        try {
            af.setAttributeType(new SelectedTag(attType, RemoveType.TAGS_ATTRIBUTETYPE));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RemoveTypeTest.fail((String)("Couldn't set up filter with attribute type: " + attType));
        }
        return af;
    }

    public void testNominalFiltering() {
        this.m_Filter = this.getFilter(1);
        Instances result = this.useFilter();
        for (int i = 0; i < result.numAttributes(); ++i) {
            RemoveTypeTest.assertTrue((result.attribute(i).type() != 1 ? 1 : 0) != 0);
        }
    }

    public void testStringFiltering() {
        this.m_Filter = this.getFilter(2);
        Instances result = this.useFilter();
        for (int i = 0; i < result.numAttributes(); ++i) {
            RemoveTypeTest.assertTrue((result.attribute(i).type() != 2 ? 1 : 0) != 0);
        }
    }

    public void testNumericFiltering() {
        this.m_Filter = this.getFilter(0);
        Instances result = this.useFilter();
        for (int i = 0; i < result.numAttributes(); ++i) {
            RemoveTypeTest.assertTrue((result.attribute(i).type() != 0 ? 1 : 0) != 0);
        }
    }

    public void testDateFiltering() {
        this.m_Filter = this.getFilter(3);
        Instances result = this.useFilter();
        for (int i = 0; i < result.numAttributes(); ++i) {
            RemoveTypeTest.assertTrue((result.attribute(i).type() != 3 ? 1 : 0) != 0);
        }
    }

    public static Test suite() {
        return new TestSuite(RemoveTypeTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RemoveTypeTest.suite());
    }
}

