/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liqp.filters.Filter;

public class Sort
extends Filter {
    @Override
    public Object apply(Object value, Object ... params) {
        if (value == null) {
            return "";
        }
        if (!super.isArray(value)) {
            throw new RuntimeException("cannot sort: " + value);
        }
        Object[] array = super.asArray(value);
        String property = params.length == 0 ? null : super.asString(params[0]);
        List<Comparable> list = this.asComparableList(array, property);
        Collections.sort(list);
        return property == null ? list.toArray(new Comparable[list.size()]) : (Comparable[])list.toArray(new SortableMap[list.size()]);
    }

    private List<Comparable> asComparableList(Object[] array, String property) {
        ArrayList<Comparable> list = new ArrayList<Comparable>();
        for (Object obj : array) {
            if (obj instanceof Map && property != null) {
                list.add(new SortableMap((Map)obj, property));
                continue;
            }
            list.add((Comparable)obj);
        }
        return list;
    }

    static class SortableMap
    extends HashMap<String, Comparable>
    implements Comparable<SortableMap> {
        final String property;

        SortableMap(Map<String, Comparable> map, String property) {
            super.putAll(map);
            this.property = property;
        }

        @Override
        public int compareTo(SortableMap that) {
            Comparable thisValue = (Comparable)this.get(this.property);
            Comparable thatValue = (Comparable)that.get(this.property);
            if (thisValue == null || thatValue == null) {
                throw new RuntimeException("Liquid error: comparison of Hash with Hash failed");
            }
            return thisValue.compareTo(thatValue);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : super.entrySet()) {
                builder.append(entry.getKey()).append(entry.getValue());
            }
            return builder.toString();
        }
    }
}

