/*
 * Decompiled with CFR 0.152.
 */
package liqp;

import java.util.LinkedHashMap;
import java.util.Map;
import liqp.ParseSettings;
import liqp.ProtectionSettings;
import liqp.RenderSettings;
import liqp.parser.Flavor;

public class TemplateContext {
    protected TemplateContext parent = null;
    public final ProtectionSettings protectionSettings;
    public final RenderSettings renderSettings;
    public final ParseSettings parseSettings;
    private Map<String, Object> variables;

    public TemplateContext() {
        this(new ProtectionSettings.Builder().build(), new RenderSettings.Builder().build(), new ParseSettings.Builder().withFlavor(Flavor.LIQUID).build(), new LinkedHashMap<String, Object>());
    }

    @Deprecated
    public TemplateContext(ProtectionSettings protectionSettings, RenderSettings renderSettings, Flavor flavor, Map<String, Object> variables) {
        this(protectionSettings, renderSettings, new ParseSettings.Builder().withFlavor(flavor).build(), variables);
    }

    public TemplateContext(ProtectionSettings protectionSettings, RenderSettings renderSettings, ParseSettings parseSettings, Map<String, Object> variables) {
        this.protectionSettings = protectionSettings;
        this.renderSettings = renderSettings;
        this.parseSettings = parseSettings;
        this.variables = new LinkedHashMap<String, Object>(variables);
    }

    public TemplateContext(TemplateContext parent) {
        this(parent.protectionSettings, parent.renderSettings, parent.parseSettings, new LinkedHashMap<String, Object>());
        this.parent = parent;
    }

    public void incrementIterations() {
        this.protectionSettings.incrementIterations();
    }

    public boolean containsKey(String key) {
        if (this.variables.containsKey(key)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.containsKey(key);
        }
        return false;
    }

    public Object get(String key) {
        Object value = this.variables.get(key);
        if (value != null) {
            return value;
        }
        if (this.parent != null) {
            return this.parent.get(key);
        }
        return null;
    }

    public Object put(String key, Object value) {
        return this.put(key, value, false);
    }

    public Object put(String key, Object value, boolean putInRootContext) {
        if (!putInRootContext || this.parent == null) {
            return this.variables.put(key, value);
        }
        return this.parent.put(key, value, putInRootContext);
    }

    public Object remove(String key) {
        if (this.variables.containsKey(key)) {
            return this.variables.remove(key);
        }
        if (this.parent != null) {
            return this.parent.remove(key);
        }
        return null;
    }

    public Map<String, Object> getVariables() {
        return new LinkedHashMap<String, Object>(this.variables);
    }
}

