/*
 * Decompiled with CFR 0.152.
 */
package liqp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import liqp.nodes.AtomNode;

public abstract class LValue {
    public static final LValue BREAK = new LValue(){

        public String toString() {
            return "";
        }
    };
    public static final LValue CONTINUE = new LValue(){

        public String toString() {
            return "";
        }
    };

    public static boolean areEqual(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof Number && b instanceof Number) {
            double delta = ((Number)a).doubleValue() - ((Number)b).doubleValue();
            return Math.abs(delta) < 1.0E-11;
        }
        if (AtomNode.isEmpty(a) && b instanceof CharSequence) {
            return ((CharSequence)b).length() == 0;
        }
        if (AtomNode.isEmpty(b) && a instanceof CharSequence) {
            return ((CharSequence)a).length() == 0;
        }
        if (AtomNode.isEmpty(a) && b instanceof Collection) {
            return ((Collection)b).size() == 0;
        }
        if (AtomNode.isEmpty(b) && a instanceof Collection) {
            return ((Collection)a).size() == 0;
        }
        if (AtomNode.isEmpty(a) && b.getClass().isArray()) {
            return ((Object[])b).length == 0;
        }
        if (AtomNode.isEmpty(b) && a.getClass().isArray()) {
            return ((Object[])a).length == 0;
        }
        if (AtomNode.isEmpty(b) && a instanceof Map) {
            return ((Map)a).size() == 0;
        }
        return a.equals(b);
    }

    public Object[] asArray(Object value) {
        if (value == null) {
            return new Object[0];
        }
        if (value.getClass().isArray()) {
            return (Object[])value;
        }
        if (value instanceof List) {
            return ((List)value).toArray();
        }
        if (value instanceof Map) {
            ArrayList<Object[]> keyValuePairs = new ArrayList<Object[]>();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                keyValuePairs.add(new Object[]{entry.getKey(), entry.getValue()});
            }
            return keyValuePairs.toArray();
        }
        return new Object[]{value};
    }

    public boolean asBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return true;
    }

    public Number asNumber(Object value) throws NumberFormatException {
        if (value instanceof Number) {
            return (Number)value;
        }
        String str = String.valueOf(value).trim();
        return str.matches("\\d+") ? (double)Long.valueOf(str).longValue() : Double.valueOf(str);
    }

    public String asString(Object value) {
        if (value == null) {
            return "";
        }
        if (!this.isArray(value)) {
            return String.valueOf(value);
        }
        Object[] array = this.asArray(value);
        StringBuilder builder = new StringBuilder();
        for (Object obj : array) {
            builder.append(this.asString(obj));
        }
        return builder.toString();
    }

    public boolean isArray(Object value) {
        return value != null && (value.getClass().isArray() || value instanceof List);
    }

    public boolean isInteger(Object value) {
        return value != null && (value instanceof Long || value instanceof Integer);
    }

    public boolean isNumber(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Number) {
            return true;
        }
        if (String.valueOf(value).trim().matches("\\d+")) {
            return true;
        }
        try {
            Double.parseDouble(String.valueOf(value).trim());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isString(Object value) {
        return value != null && value instanceof CharSequence;
    }

    public boolean isTruthy(Object value) {
        return !this.isFalsy(value);
    }

    public boolean isFalsy(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
            return true;
        }
        if (value instanceof CharSequence && ((CharSequence)value).length() == 0) {
            return true;
        }
        if (this.isArray(value) && this.asArray(value).length == 0) {
            return true;
        }
        return value instanceof Map && ((Map)value).isEmpty();
    }

    public boolean canBeInteger(Object value) {
        return String.valueOf(value).trim().matches("-?\\d+");
    }

    public boolean canBeDouble(Object value) {
        return String.valueOf(value).trim().matches("-?\\d+(\\.\\d*)?");
    }

    public boolean isMap(Object value) {
        return value != null && value instanceof Map;
    }

    public Map<String, Object> asMap(Object value) {
        return (Map)value;
    }
}

