/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters;

import java.util.Arrays;
import java.util.HashMap;
import liqp.LValue;
import liqp.TemplateContext;
import liqp.filters.Abs;
import liqp.filters.Append;
import liqp.filters.At_Least;
import liqp.filters.At_Most;
import liqp.filters.Capitalize;
import liqp.filters.Ceil;
import liqp.filters.Compact;
import liqp.filters.Concat;
import liqp.filters.Date;
import liqp.filters.Default;
import liqp.filters.Divided_By;
import liqp.filters.Downcase;
import liqp.filters.Escape;
import liqp.filters.Escape_Once;
import liqp.filters.First;
import liqp.filters.Floor;
import liqp.filters.H;
import liqp.filters.Join;
import liqp.filters.Last;
import liqp.filters.Lstrip;
import liqp.filters.Map;
import liqp.filters.Minus;
import liqp.filters.Modulo;
import liqp.filters.Newline_To_Br;
import liqp.filters.Plus;
import liqp.filters.Prepend;
import liqp.filters.Remove;
import liqp.filters.Remove_First;
import liqp.filters.Replace;
import liqp.filters.Replace_First;
import liqp.filters.Reverse;
import liqp.filters.Round;
import liqp.filters.Rstrip;
import liqp.filters.Size;
import liqp.filters.Slice;
import liqp.filters.Sort;
import liqp.filters.Sort_Natural;
import liqp.filters.Split;
import liqp.filters.Strip;
import liqp.filters.Strip_HTML;
import liqp.filters.Strip_Newlines;
import liqp.filters.Times;
import liqp.filters.Truncate;
import liqp.filters.Truncatewords;
import liqp.filters.Uniq;
import liqp.filters.Upcase;
import liqp.filters.Url_Decode;
import liqp.filters.Url_Encode;

public abstract class Filter
extends LValue {
    private static final java.util.Map<String, Filter> FILTERS = new HashMap<String, Filter>();
    public final String name;

    private static void addDefaultFilters() {
        Filter.registerFilter(new Abs());
        Filter.registerFilter(new Append());
        Filter.registerFilter(new At_Least());
        Filter.registerFilter(new At_Most());
        Filter.registerFilter(new Capitalize());
        Filter.registerFilter(new Ceil());
        Filter.registerFilter(new Compact());
        Filter.registerFilter(new Concat());
        Filter.registerFilter(new Date());
        Filter.registerFilter(new Default());
        Filter.registerFilter(new Divided_By());
        Filter.registerFilter(new Downcase());
        Filter.registerFilter(new Escape());
        Filter.registerFilter(new Escape_Once());
        Filter.registerFilter(new First());
        Filter.registerFilter(new Floor());
        Filter.registerFilter(new H());
        Filter.registerFilter(new Join());
        Filter.registerFilter(new Last());
        Filter.registerFilter(new Lstrip());
        Filter.registerFilter(new Map());
        Filter.registerFilter(new Minus());
        Filter.registerFilter(new Modulo());
        Filter.registerFilter(new Newline_To_Br());
        Filter.registerFilter(new Plus());
        Filter.registerFilter(new Prepend());
        Filter.registerFilter(new Remove());
        Filter.registerFilter(new Remove_First());
        Filter.registerFilter(new Replace());
        Filter.registerFilter(new Replace_First());
        Filter.registerFilter(new Reverse());
        Filter.registerFilter(new Round());
        Filter.registerFilter(new Rstrip());
        Filter.registerFilter(new Size());
        Filter.registerFilter(new Slice());
        Filter.registerFilter(new Sort());
        Filter.registerFilter(new Sort_Natural());
        Filter.registerFilter(new Split());
        Filter.registerFilter(new Strip());
        Filter.registerFilter(new Strip_HTML());
        Filter.registerFilter(new Strip_Newlines());
        Filter.registerFilter(new Times());
        Filter.registerFilter(new Truncate());
        Filter.registerFilter(new Truncatewords());
        Filter.registerFilter(new Uniq());
        Filter.registerFilter(new Upcase());
        Filter.registerFilter(new Url_Decode());
        Filter.registerFilter(new Url_Encode());
    }

    protected Filter() {
        this.name = this.getClass().getSimpleName().toLowerCase();
    }

    public Filter(String name) {
        this.name = name;
    }

    public Object apply(Object value, Object ... params) {
        return value;
    }

    public Object apply(Object value, TemplateContext context, Object ... params) {
        return this.apply(value, params);
    }

    final void checkParams(Object[] params, int expected) {
        if (params == null || params.length != expected) {
            throw new RuntimeException("Liquid error: wrong number of arguments (given " + (params == null ? 1 : params.length + 1) + " for " + (expected + 1) + ")");
        }
    }

    final void checkParams(Object[] params, int min, int max) {
        if (params == null || params.length < min || params.length > max) {
            throw new RuntimeException("Liquid error: wrong number of arguments (given " + (params == null ? 1 : params.length + 1) + " expected " + (min + 1) + ".." + (max + 1) + ")");
        }
    }

    protected Object get(int index, Object ... params) {
        if (index >= params.length) {
            throw new RuntimeException("error in filter '" + this.name + "': cannot get param index: " + index + " from: " + Arrays.toString(params));
        }
        return params[index];
    }

    public static Filter getFilter(String name) {
        Filter filter = FILTERS.get(name);
        if (filter == null) {
            throw new RuntimeException("unknown filter: " + name);
        }
        return filter;
    }

    public static java.util.Map<String, Filter> getFilters() {
        return new HashMap<String, Filter>(FILTERS);
    }

    public static void registerFilter(Filter filter) {
        FILTERS.put(filter.name, filter);
    }

    private static void resetFilters() {
        FILTERS.clear();
        Filter.addDefaultFilters();
    }

    static {
        Filter.addDefaultFilters();
    }
}

