/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.objects.NameUtil;

public class AttributeDelta {
    private final String name;
    private final List<Object> valuesToAdd;
    private final List<Object> valuesToRemove;
    private final List<Object> valuesToReplace;

    AttributeDelta(String name, List<Object> valuesToAdd, List<Object> valuesToRemove, List<Object> valuesToReplace) {
        if (StringUtil.isBlank(name)) {
            throw new IllegalArgumentException("Name must not be blank!");
        }
        this.name = name;
        if (valuesToReplace != null && (valuesToAdd != null || valuesToRemove != null)) {
            throw new IllegalArgumentException("Delta of attribute '" + name + "' may be either replace or add/remove but not both at the same time");
        }
        this.valuesToAdd = valuesToAdd == null ? null : CollectionUtil.newReadOnlyList(valuesToAdd);
        this.valuesToRemove = valuesToRemove == null ? null : CollectionUtil.newReadOnlyList(valuesToRemove);
        this.valuesToReplace = valuesToReplace == null ? null : CollectionUtil.newReadOnlyList(valuesToReplace);
    }

    public String getName() {
        return this.name;
    }

    public List<Object> getValuesToAdd() {
        return this.valuesToAdd == null ? null : Collections.unmodifiableList(this.valuesToAdd);
    }

    public List<Object> getValuesToRemove() {
        return this.valuesToRemove == null ? null : Collections.unmodifiableList(this.valuesToRemove);
    }

    public List<Object> getValuesToReplace() {
        return this.valuesToReplace == null ? null : Collections.unmodifiableList(this.valuesToReplace);
    }

    public boolean is(String name) {
        return NameUtil.namesEqual(this.name, name);
    }

    public final int hashCode() {
        return NameUtil.nameHashCode(this.name);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("Attribute: ");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("Name", this.getName());
        map.put("ValuesToAdd", this.getValuesToAdd());
        map.put("ValuesToRemove", this.getValuesToRemove());
        map.put("ValuesToReplace", this.getValuesToReplace());
        this.extendToStringMap(map);
        bld.append(map);
        return bld.toString();
    }

    protected void extendToStringMap(Map<String, Object> map) {
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        AttributeDelta other = (AttributeDelta)obj;
        if (!this.is(other.name)) {
            return false;
        }
        if (!CollectionUtil.equals(this.valuesToAdd, other.valuesToAdd)) {
            return false;
        }
        if (!CollectionUtil.equals(this.valuesToRemove, other.valuesToRemove)) {
            return false;
        }
        return CollectionUtil.equals(this.valuesToReplace, other.valuesToReplace);
    }
}

