/*
 * Decompiled with CFR 0.152.
 */
package net.theblackchamber.crypto.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStoreException;
import java.util.Properties;
import net.theblackchamber.crypto.implementations.SecureProperties2;
import org.apache.commons.lang3.StringUtils;

public class SecurePropertiesUtils2 {
    public static SecureProperties2 encryptPropertiesFile(File clearProperties) throws KeyStoreException, IOException {
        if (clearProperties == null || !clearProperties.exists() || !clearProperties.canRead()) {
            throw new KeyStoreException("Unable to configure due to missing or unreadable properties file.");
        }
        Properties cProperties = new Properties();
        FileInputStream fis = new FileInputStream(clearProperties);
        cProperties.load(fis);
        fis.close();
        return SecurePropertiesUtils2.encryptPropertiesFile(clearProperties, cProperties.getProperty("key-path"), cProperties.getProperty("keystore-password"), true);
    }

    public static SecureProperties2 encryptPropertiesFile(File clearProperties, String keyPath, String keyPass) throws FileNotFoundException, IOException, KeyStoreException {
        return SecurePropertiesUtils2.encryptPropertiesFile(clearProperties, keyPath, keyPass, false);
    }

    public static SecureProperties2 encryptPropertiesFile(File clearProperties, String keyPath, String keyPass, boolean retainCrytoConfigProperties) throws FileNotFoundException, IOException, KeyStoreException {
        String propertiesFilePath = clearProperties.getPath();
        SecureProperties2 sProperties = new SecureProperties2();
        Properties cProperties = new Properties();
        FileInputStream fis = new FileInputStream(clearProperties);
        cProperties.load(fis);
        fis.close();
        if (StringUtils.isEmpty((CharSequence)keyPath) || StringUtils.isEmpty((CharSequence)keyPass)) {
            throw new KeyStoreException("Unable to configure due to missing configurations");
        }
        sProperties.setProperty("keystore-password", keyPass);
        sProperties.setProperty("key-path", keyPath);
        for (Object key : cProperties.keySet()) {
            String keyStr = (String)key;
            if (StringUtils.equals((CharSequence)keyStr, (CharSequence)"key-path") || StringUtils.equals((CharSequence)keyStr, (CharSequence)"keystore-password")) continue;
            sProperties.setProperty(keyStr, cProperties.getProperty(keyStr));
        }
        if (!retainCrytoConfigProperties) {
            sProperties.remove("key-path");
            sProperties.remove("keystore-password");
        }
        clearProperties.delete();
        FileOutputStream fos = new FileOutputStream(new File(propertiesFilePath));
        sProperties.store(fos, "File Encrypted by SecurePropertiesUtils2");
        fos.flush();
        ((OutputStream)fos).close();
        return sProperties;
    }
}

