/*
 * Decompiled with CFR 0.152.
 */
package net.theblackchamber.crypto.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStoreException;
import java.util.Properties;
import net.theblackchamber.crypto.implementations.SecureProperties;
import org.apache.commons.lang3.StringUtils;

public class SecurePropertiesUtils {
    public static SecureProperties encryptPropertiesFile(File clearProperties) throws FileNotFoundException, IOException, KeyStoreException {
        Properties cProperties = new Properties();
        FileInputStream fis = new FileInputStream(clearProperties);
        cProperties.load(fis);
        fis.close();
        return SecurePropertiesUtils.encryptPropertiesFile(clearProperties, cProperties.getProperty("key-path"), cProperties.getProperty("keystore-password"), cProperties.getProperty("entry-name"), true);
    }

    public static SecureProperties encryptPropertiesFile(File clearProperties, String keyPath, String keyPass, String keyEntry) throws FileNotFoundException, IOException, KeyStoreException {
        return SecurePropertiesUtils.encryptPropertiesFile(clearProperties, keyPath, keyPass, keyEntry, false);
    }

    public static SecureProperties encryptPropertiesFile(File clearProperties, String keyPath, String keyPass, String keyEntry, boolean retainCrytoConfigProperties) throws FileNotFoundException, IOException, KeyStoreException {
        String propertiesFilePath = clearProperties.getPath();
        SecureProperties sProperties = new SecureProperties();
        Properties cProperties = new Properties();
        FileInputStream fis = new FileInputStream(clearProperties);
        cProperties.load(fis);
        fis.close();
        if (StringUtils.isEmpty((CharSequence)keyEntry) || StringUtils.isEmpty((CharSequence)keyPath) || StringUtils.isEmpty((CharSequence)keyPass)) {
            throw new KeyStoreException("Unable to configure due to missing configurations");
        }
        sProperties.setProperty("entry-name", keyEntry);
        sProperties.setProperty("keystore-password", keyPass);
        sProperties.setProperty("key-path", keyPath);
        for (Object key : cProperties.keySet()) {
            String keyStr = (String)key;
            if (StringUtils.equals((CharSequence)keyStr, (CharSequence)"entry-name") || StringUtils.equals((CharSequence)keyStr, (CharSequence)"keystore-password") || StringUtils.equals((CharSequence)keyStr, (CharSequence)"key-path")) continue;
            sProperties.setProperty(keyStr, cProperties.getProperty(keyStr));
        }
        if (!retainCrytoConfigProperties) {
            sProperties.remove("entry-name");
            sProperties.remove("keystore-password");
            sProperties.remove("key-path");
        }
        clearProperties.delete();
        FileOutputStream fos = new FileOutputStream(new File(propertiesFilePath));
        sProperties.store(fos, "File Encrypted by SecurePropertiesUtils");
        fos.flush();
        ((OutputStream)fos).close();
        return sProperties;
    }
}

