/*
 * Decompiled with CFR 0.152.
 */
package net.theblackchamber.crypto.util;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.JsonKeysetReader;
import com.google.crypto.tink.JsonKeysetWriter;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.aead.AesGcmKeyManager;
import com.google.crypto.tink.config.TinkConfig;
import com.google.crypto.tink.subtle.AesGcmJce;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import net.theblackchamber.crypto.model.KeyConfig2;
import net.theblackchamber.crypto.providers.digest.SHA256DigestProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class KeystoreUtils2 {
    private static SHA256DigestProvider digest = new SHA256DigestProvider(SHA256DigestProvider.TYPE.SHA1);

    public static void generateSecretKey(KeyConfig2 config) throws IOException, GeneralSecurityException {
        if (config == null || config.getKeyStoreFile() == null || StringUtils.isBlank((CharSequence)config.getKeyPass())) {
            throw new KeyStoreException("Missing parameters, unable to create keystore.");
        }
        TinkConfig.register();
        KeysetHandle keysetHandle = KeysetHandle.generateNew((KeyTemplate)AesGcmKeyManager.aes256GcmTemplate());
        String dKey = digest.digest(config.getKeyPass());
        AesGcmJce aesKey = new AesGcmJce(dKey.substring(0, 32).getBytes());
        ByteArrayOutputStream privateOutputStream = new ByteArrayOutputStream();
        keysetHandle.write(JsonKeysetWriter.withOutputStream((OutputStream)privateOutputStream), (Aead)aesKey);
        byte[] privateBytes = privateOutputStream.toByteArray();
        FileUtils.writeByteArrayToFile((File)config.getKeyStoreFile(), (byte[])privateBytes);
    }

    public static KeysetHandle getSecretKey(KeyConfig2 config) throws IOException, GeneralSecurityException {
        if (config == null || config.getKeyStoreFile() == null || StringUtils.isBlank((CharSequence)config.getKeyPass())) {
            throw new KeyStoreException("Missing parameters, unable to create keystore.");
        }
        TinkConfig.register();
        String dKey = digest.digest(config.getKeyPass());
        AesGcmJce aesKey = new AesGcmJce(dKey.substring(0, 32).getBytes());
        byte[] encryptedBytes = FileUtils.readFileToByteArray((File)config.getKeyStoreFile());
        return KeysetHandle.read((KeysetReader)JsonKeysetReader.withBytes((byte[])encryptedBytes), (Aead)aesKey);
    }
}

