/*
 * Decompiled with CFR 0.152.
 */
package net.theblackchamber.crypto.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import net.theblackchamber.crypto.model.KeyConfig;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KeystoreUtils {
    public static void generateSecretKey(KeyConfig config) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        if (config == null || config.getKeyStoreFile() == null || StringUtils.isEmpty((CharSequence)config.getKeyEntryName()) || config.getAlgorithm() == null) {
            throw new KeyStoreException("Missing parameters, unable to create keystore.");
        }
        SecureRandom random = new SecureRandom();
        KeyGenerator keygen = KeyGenerator.getInstance(config.getAlgorithm().getName(), (Provider)new BouncyCastleProvider());
        keygen.init(config.getKeySize(), random);
        SecretKey key = keygen.generateKey();
        KeyStore keyStore = KeyStore.getInstance("JCEKS");
        FileInputStream fis = null;
        if (config.getKeyStoreFile().exists() && FileUtils.sizeOf((File)config.getKeyStoreFile()) > 0L) {
            fis = new FileInputStream(config.getKeyStoreFile());
        }
        keyStore.load(fis, config.getKeyStorePassword().toCharArray());
        KeyStore.PasswordProtection protectionParameter = new KeyStore.PasswordProtection(config.getKeyStorePassword().toCharArray());
        KeyStore.SecretKeyEntry secretKeyEntry = new KeyStore.SecretKeyEntry(key);
        keyStore.setEntry(config.getKeyEntryName(), secretKeyEntry, protectionParameter);
        if (fis != null) {
            fis.close();
        }
        FileOutputStream fos = new FileOutputStream(config.getKeyStoreFile());
        keyStore.store(fos, config.getKeyStorePassword().toCharArray());
        fos.close();
    }

    public static SecretKey getSecretKey(File keystore, String entryName, String keyStorePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, UnrecoverableEntryException {
        KeyStore keyStore = KeyStore.getInstance("JCEKS");
        FileInputStream fis = null;
        if (keystore == null || !keystore.exists() || FileUtils.sizeOf((File)keystore) == 0L) {
            throw new FileNotFoundException();
        }
        if (StringUtils.isEmpty((CharSequence)keyStorePassword)) {
            throw new KeyStoreException("No Keystore password provided.");
        }
        if (StringUtils.isEmpty((CharSequence)entryName)) {
            throw new KeyStoreException("No Keystore entry name provided.");
        }
        fis = new FileInputStream(keystore);
        return KeystoreUtils.getSecretKey(fis, entryName, keyStorePassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecretKey getSecretKey(InputStream keyInputStream, String entryName, String keyStorePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableEntryException {
        KeyStore keyStore = KeyStore.getInstance("JCEKS");
        if (keyInputStream == null) {
            throw new KeyStoreException("No Keystore stream provided.");
        }
        if (StringUtils.isEmpty((CharSequence)keyStorePassword)) {
            throw new KeyStoreException("No Keystore password provided.");
        }
        if (StringUtils.isEmpty((CharSequence)entryName)) {
            throw new KeyStoreException("No Keystore entry name provided.");
        }
        keyStore.load(keyInputStream, keyStorePassword.toCharArray());
        KeyStore.PasswordProtection protectionParameter = new KeyStore.PasswordProtection(keyStorePassword.toCharArray());
        KeyStore.SecretKeyEntry pkEntry = (KeyStore.SecretKeyEntry)keyStore.getEntry(entryName, protectionParameter);
        try {
            SecretKey secretKey = pkEntry.getSecretKey();
            return secretKey;
        }
        finally {
            keyInputStream.close();
        }
    }
}

