/*
 * Decompiled with CFR 0.152.
 */
package net.theblackchamber.crypto.providers.symmetric;

import java.security.Key;
import java.security.Provider;
import net.theblackchamber.crypto.constants.SupportedEncryptionAlgorithms;
import net.theblackchamber.crypto.exceptions.UnsupportedAlgorithmException;
import net.theblackchamber.crypto.exceptions.UnsupportedKeySizeException;
import net.theblackchamber.crypto.providers.EncryptionProvider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.jasypt.encryption.pbe.PooledPBEByteEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.encryption.pbe.config.SimplePBEConfig;
import org.jasypt.salt.RandomSaltGenerator;
import org.jasypt.salt.SaltGenerator;

@Deprecated
public class AESEncryptionProvider
extends EncryptionProvider {
    public AESEncryptionProvider(Key key) throws UnsupportedKeySizeException, UnsupportedAlgorithmException {
        super(key);
        int keySize = key.getEncoded().length * 8;
        SimplePBEConfig config = new SimplePBEConfig();
        switch (keySize) {
            case 128: {
                config.setAlgorithm(SupportedEncryptionAlgorithms.AES128.getAlgorithm());
                break;
            }
            case 192: {
                config.setAlgorithm(SupportedEncryptionAlgorithms.AES192.getAlgorithm());
                break;
            }
            default: {
                config.setAlgorithm(SupportedEncryptionAlgorithms.AES256.getAlgorithm());
            }
        }
        config.setKeyObtentionIterations(Integer.valueOf(10));
        config.setPassword(Hex.toHexString((byte[])key.getEncoded()));
        config.setProvider((Provider)new BouncyCastleProvider());
        config.setSaltGenerator((SaltGenerator)new RandomSaltGenerator());
        this.stringEncryptor = new PooledPBEStringEncryptor();
        this.stringEncryptor.setPoolSize(this.ENCRYPTOR_POOL_SIZE);
        this.stringEncryptor.setConfig((PBEConfig)config);
        this.stringEncryptor.setStringOutputType("hexadecimal");
        this.byteEncryptor = new PooledPBEByteEncryptor();
        this.byteEncryptor.setPoolSize(this.ENCRYPTOR_POOL_SIZE);
        this.byteEncryptor.setConfig((PBEConfig)config);
    }

    @Override
    protected void validateKey(Key key) throws UnsupportedKeySizeException, UnsupportedAlgorithmException {
        byte[] keyBytes = key.getEncoded();
        if (keyBytes.length != 16 && keyBytes.length != 24 && keyBytes.length != 32) {
            throw new UnsupportedKeySizeException("Found unsupported key size [" + keyBytes.length * 8 + "]. The AES algorithm only supports key sizes of 128, 192, or 256");
        }
        if (!"AES".equals(key.getAlgorithm())) {
            throw new UnsupportedAlgorithmException("Key does not support AES algorithm: [" + key.getAlgorithm() + "]");
        }
    }
}

