/*
 * Decompiled with CFR 0.152.
 */
package net.theblackchamber.crypto.providers.digest;

import java.security.Provider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jasypt.digest.config.DigesterConfig;
import org.jasypt.digest.config.SimpleDigesterConfig;
import org.jasypt.util.password.ConfigurablePasswordEncryptor;

public class WhirlpoolDigestProvider {
    private ConfigurablePasswordEncryptor encryptor;

    public WhirlpoolDigestProvider() {
        SimpleDigesterConfig config = new SimpleDigesterConfig();
        config.setAlgorithm("WHIRLPOOL");
        config.setIterations(Integer.valueOf(50000));
        config.setProvider((Provider)new BouncyCastleProvider());
        this.encryptor = new ConfigurablePasswordEncryptor();
        this.encryptor.setProvider((Provider)new BouncyCastleProvider());
        this.encryptor.setAlgorithm("WHIRLPOOL");
        this.encryptor.setConfig((DigesterConfig)config);
        this.encryptor.setPlainDigest(true);
        this.encryptor.setStringOutputType("hexadecimal");
    }

    public String digest(String clear) {
        return this.encryptor.encryptPassword(clear);
    }
}

