/*
 * Decompiled with CFR 0.152.
 */
package net.theblackchamber.crypto.providers.digest;

import java.security.Provider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jasypt.digest.config.DigesterConfig;
import org.jasypt.digest.config.SimpleDigesterConfig;
import org.jasypt.util.password.ConfigurablePasswordEncryptor;

public class SHA256DigestProvider {
    private ConfigurablePasswordEncryptor encryptor;

    public SHA256DigestProvider(TYPE type) {
        SimpleDigesterConfig config = new SimpleDigesterConfig();
        config.setAlgorithm(type.getValue());
        config.setIterations(Integer.valueOf(50000));
        config.setProvider((Provider)new BouncyCastleProvider());
        this.encryptor = new ConfigurablePasswordEncryptor();
        this.encryptor.setProvider((Provider)new BouncyCastleProvider());
        this.encryptor.setAlgorithm(type.getValue());
        this.encryptor.setConfig((DigesterConfig)config);
        this.encryptor.setPlainDigest(true);
        this.encryptor.setStringOutputType("hexadecimal");
    }

    public String digest(String clear) {
        return this.encryptor.encryptPassword(clear);
    }

    public static enum TYPE {
        SHA1("SHA-1"),
        SHA256("SHA-256"),
        SHA384("SHA-384"),
        SHA512("SHA-512");

        String value;

        private TYPE(String string2) {
            this.value = string2;
        }

        String getValue() {
            return this.value;
        }
    }
}

