/*
 * Decompiled with CFR 0.152.
 */
package net.theblackchamber.crypto.providers;

import com.google.crypto.tink.KeysetHandle;
import java.security.GeneralSecurityException;
import java.util.Base64;
import lombok.NonNull;
import net.theblackchamber.crypto.exceptions.MissingParameterException;
import org.apache.commons.lang3.StringUtils;

public abstract class EncryptionProvider2 {
    @NonNull
    private KeysetHandle key;
    Base64.Encoder encoder = Base64.getEncoder();
    Base64.Decoder decoder = Base64.getDecoder();

    protected abstract byte[] performEncryption(byte[] var1, byte[] var2) throws GeneralSecurityException;

    protected abstract byte[] performDecryption(byte[] var1, byte[] var2) throws GeneralSecurityException;

    public String decrypt(String cipherText, String associated) throws MissingParameterException, GeneralSecurityException {
        if (StringUtils.isBlank((CharSequence)cipherText)) {
            throw new MissingParameterException("Missing parameter: cipherText");
        }
        return new String(this.performDecryption(this.decoder.decode(cipherText), associated.getBytes()));
    }

    public String decrypt(String cipherText) throws MissingParameterException, GeneralSecurityException {
        return this.decrypt(cipherText, "");
    }

    public String encrypt(String clearText, String associated) throws MissingParameterException, GeneralSecurityException {
        if (StringUtils.isBlank((CharSequence)clearText)) {
            throw new MissingParameterException("Missing parameter: clearText");
        }
        return this.encoder.encodeToString(this.performEncryption(clearText.getBytes(), associated.getBytes()));
    }

    public byte[] encrypt(byte[] clearText, byte[] associated) throws MissingParameterException, GeneralSecurityException {
        if (clearText == null || clearText.length == 0) {
            throw new MissingParameterException("Missing parameter: clearText");
        }
        if (associated == null) {
            associated = new byte[]{};
        }
        return this.performEncryption(clearText, associated);
    }

    public byte[] encrypt(byte[] clearText) throws MissingParameterException, GeneralSecurityException {
        if (clearText == null || clearText.length == 0) {
            throw new MissingParameterException("Missing parameter: clearText");
        }
        return this.performEncryption(clearText, null);
    }

    public byte[] decrypt(byte[] cipherText, byte[] associated) throws MissingParameterException, GeneralSecurityException {
        if (cipherText == null || cipherText.length == 0) {
            throw new MissingParameterException("Missing parameter: cipherText");
        }
        if (associated == null) {
            associated = new byte[]{};
        }
        return this.performDecryption(cipherText, associated);
    }

    public byte[] decrypt(byte[] cipherText) throws MissingParameterException, GeneralSecurityException {
        if (cipherText == null || cipherText.length == 0) {
            throw new MissingParameterException("Missing parameter: cipherText");
        }
        return this.performDecryption(cipherText, null);
    }

    public String encrypt(String clearText) throws MissingParameterException, GeneralSecurityException {
        return this.encrypt(clearText, "");
    }

    @NonNull
    public KeysetHandle getKey() {
        return this.key;
    }

    public Base64.Encoder getEncoder() {
        return this.encoder;
    }

    public Base64.Decoder getDecoder() {
        return this.decoder;
    }

    public EncryptionProvider2(@NonNull KeysetHandle key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
    }
}

