/*
 * Decompiled with CFR 0.152.
 */
package net.theblackchamber.crypto.providers;

import java.security.Key;
import net.theblackchamber.crypto.exceptions.MissingParameterException;
import net.theblackchamber.crypto.exceptions.UnsupportedAlgorithmException;
import net.theblackchamber.crypto.exceptions.UnsupportedKeySizeException;
import org.apache.commons.lang3.StringUtils;
import org.jasypt.encryption.pbe.PooledPBEByteEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;

public abstract class EncryptionProvider {
    protected int ENCRYPTOR_POOL_SIZE = 4;
    protected PooledPBEStringEncryptor stringEncryptor;
    protected PooledPBEByteEncryptor byteEncryptor;
    private Key key;

    protected Key getKey() {
        return this.key;
    }

    protected void setKey(Key key) {
        this.key = key;
    }

    public String decrypt(String cipherText) throws MissingParameterException {
        if (StringUtils.isBlank((CharSequence)cipherText)) {
            throw new MissingParameterException("Missing parameter: cipherText");
        }
        return this.stringEncryptor.decrypt(cipherText);
    }

    public String encrypt(String clearText) throws MissingParameterException {
        if (StringUtils.isBlank((CharSequence)clearText)) {
            throw new MissingParameterException("Missing parameter: clearText");
        }
        return this.stringEncryptor.encrypt(clearText);
    }

    public byte[] encrypt(byte[] clearBytes) throws MissingParameterException {
        if (clearBytes.length == 0) {
            throw new MissingParameterException("Missing parameter: clearBytes");
        }
        return this.byteEncryptor.encrypt(clearBytes);
    }

    public byte[] decrypt(byte[] cipherBytes) throws MissingParameterException {
        if (cipherBytes == null || cipherBytes.length == 0) {
            throw new MissingParameterException("Missing parameter: cipherBytes");
        }
        return this.byteEncryptor.decrypt(cipherBytes);
    }

    protected abstract void validateKey(Key var1) throws UnsupportedKeySizeException, UnsupportedAlgorithmException;

    public EncryptionProvider(Key key) throws UnsupportedKeySizeException, UnsupportedAlgorithmException {
        this.validateKey(key);
        this.setKey(key);
    }
}

