/*
 * Decompiled with CFR 0.152.
 */
package net.theblackchamber.crypto.model;

import java.io.File;
import net.theblackchamber.crypto.constants.SupportedKeyGenAlgorithms;

public class KeyConfig {
    private static final int DEFAULT_AES_KEY_SIZE = 256;
    private static final int DEFAULT_DES_KEY_SIZE = 192;
    private File keyStoreFile = null;
    private String keyStorePassword = null;
    private Integer keySize = null;
    private SupportedKeyGenAlgorithms algorithm = null;
    private String keyEntryName = null;

    public KeyConfig() {
    }

    public KeyConfig(File keyStoreFile, String keyStorePassword, Integer keySize, SupportedKeyGenAlgorithms algorithm, String keyEntryName) {
        this.keyStoreFile = keyStoreFile;
        this.keyStorePassword = keyStorePassword;
        this.keySize = keySize;
        this.algorithm = algorithm;
        this.keyEntryName = keyEntryName;
    }

    public File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(File keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyEntryName() {
        return this.keyEntryName;
    }

    public void setKeyEntryName(String keyEntryName) {
        this.keyEntryName = keyEntryName;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public Integer getKeySize() {
        if (this.keySize == null) {
            switch (this.algorithm) {
                case DES: {
                    this.keySize = 192;
                    break;
                }
                default: {
                    this.keySize = 256;
                }
            }
        }
        return this.keySize;
    }

    public void setKeySize(Integer keySize) {
        this.keySize = keySize;
    }

    public SupportedKeyGenAlgorithms getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(SupportedKeyGenAlgorithms algorithm) {
        this.algorithm = algorithm;
    }
}

