/*
 * Decompiled with CFR 0.152.
 */
package net.theblackchamber.crypto.implementations;

import com.google.crypto.tink.KeysetHandle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import net.theblackchamber.crypto.exceptions.MissingParameterException;
import net.theblackchamber.crypto.exceptions.RuntimeCryptoException;
import net.theblackchamber.crypto.model.KeyConfig2;
import net.theblackchamber.crypto.providers.EncryptionProvider2;
import net.theblackchamber.crypto.providers.EncryptionProviderFactory2;
import net.theblackchamber.crypto.util.KeystoreUtils2;
import org.apache.commons.lang3.StringUtils;

public class SecureProperties2
extends Properties {
    private static final long serialVersionUID = 6795084558089471182L;
    private static final String ENCRYPTED_SUFFIX = "-encrypted";
    private static final String UNENCRYPTED_SUFFIX = "-unencrypted";
    private KeysetHandle key = null;
    private EncryptionProvider2 encryptionProvider = null;

    public KeysetHandle getKey() {
        return this.key;
    }

    public EncryptionProvider2 getEncryptionProvider() {
        return this.encryptionProvider;
    }

    public SecureProperties2() {
    }

    public SecureProperties2(String propertiesPath, String keyPath, String keyPass) throws FileNotFoundException, IOException {
        super.load(new FileInputStream(new File(propertiesPath)));
        try {
            this.loadKeystore(keyPath, keyPass);
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    public SecureProperties2(InputStream inputStream, String keyPath, String keyPass) throws IOException {
        super.load(inputStream);
        try {
            if (StringUtils.isEmpty((CharSequence)keyPath)) {
                keyPath = this.getProperty("key-path");
            }
            if (StringUtils.isEmpty((CharSequence)keyPass)) {
                keyPass = this.getProperty("keystore-password");
            }
            this.loadKeystore(keyPath, keyPass);
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    public SecureProperties2(File propertiesFile, String keyPath, String keyPass) throws FileNotFoundException, IOException {
        super.load(new FileInputStream(propertiesFile));
        try {
            if (StringUtils.isEmpty((CharSequence)keyPath)) {
                keyPath = this.getProperty("key-path");
            }
            if (StringUtils.isEmpty((CharSequence)keyPass)) {
                keyPass = this.getProperty("keystore-password");
            }
            this.loadKeystore(keyPath, keyPass);
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    public SecureProperties2(Properties defaults, String keyPath, String keyPass) throws IOException {
        super(defaults);
        try {
            if (StringUtils.isEmpty((CharSequence)keyPath)) {
                keyPath = this.getProperty("key-path");
            }
            if (StringUtils.isEmpty((CharSequence)keyPass)) {
                keyPass = this.getProperty("keystore-password");
            }
            this.loadKeystore(keyPath, keyPass);
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    public SecureProperties2(String propertiesPath) throws FileNotFoundException, IOException {
        super.load(new FileInputStream(new File(propertiesPath)));
        try {
            this.loadKeystore();
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    public SecureProperties2(File propertiesFile) throws FileNotFoundException, IOException {
        super.load(new FileInputStream(propertiesFile));
        try {
            this.loadKeystore();
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    public SecureProperties2(Properties defaults) throws IOException {
        super(defaults);
        try {
            this.loadKeystore();
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    public SecureProperties2(InputStream inputStream) throws IOException {
        super.load(inputStream);
        try {
            this.loadKeystore();
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        super.load(reader);
        try {
            this.loadKeystore();
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        super.load(inStream);
        try {
            this.loadKeystore();
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    @Override
    public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        super.loadFromXML(in);
        try {
            this.loadKeystore();
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    @Override
    public String getProperty(String key) {
        String property = super.getProperty(key);
        return this.attemptDecryption(key, property);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String property = this.getProperty(key);
        if (StringUtils.isEmpty((CharSequence)property)) {
            return defaultValue;
        }
        return property;
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        String property;
        if (StringUtils.equalsIgnoreCase((CharSequence)"key-path", (CharSequence)key)) {
            super.setProperty(key, value);
            this.loadKeystore();
            this.initializeEncryptionProvider();
        }
        if (!StringUtils.equals((CharSequence)(property = this.attemptEncryption(key, value)), (CharSequence)value)) {
            key = StringUtils.replace((String)key, (String)UNENCRYPTED_SUFFIX, (String)ENCRYPTED_SUFFIX);
        }
        return super.setProperty(key, property);
    }

    private String attemptDecryption(String key, String property) {
        try {
            if (StringUtils.endsWithIgnoreCase((CharSequence)key, (CharSequence)ENCRYPTED_SUFFIX)) {
                if (this.encryptionProvider == null) {
                    throw new RuntimeCryptoException("No encryption provider configured");
                }
                return this.encryptionProvider.decrypt(property);
            }
            return property;
        }
        catch (MissingParameterException e) {
            throw new RuntimeCryptoException("No value to encrypt specified");
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeCryptoException("Error Decrypting: " + e.getMessage(), e);
        }
    }

    private String attemptEncryption(String key, String property) {
        try {
            if (StringUtils.endsWithIgnoreCase((CharSequence)key, (CharSequence)UNENCRYPTED_SUFFIX)) {
                if (this.encryptionProvider == null) {
                    throw new RuntimeCryptoException("No encryption provider configured");
                }
                return this.encryptionProvider.encrypt(property);
            }
            return property;
        }
        catch (MissingParameterException mpre) {
            throw new RuntimeCryptoException("No value to decrypt specified.");
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeCryptoException("Error encrypting: " + e.getMessage(), e);
        }
    }

    private void initializeEncryptionProvider() {
        if (this.key != null) {
            try {
                this.encryptionProvider = EncryptionProviderFactory2.getProvider(this.key);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeCryptoException(e.getMessage(), e);
            }
        }
    }

    private void loadKeystore() {
        String keypath = this.getProperty("key-path");
        String keypass = this.getProperty("keystore-password");
        this.loadKeystore(keypath, keypass);
    }

    private void loadKeystore(String keyPath, String keyPass) {
        if (!StringUtils.isEmpty((CharSequence)keyPath)) {
            try {
                this.key = KeystoreUtils2.getSecretKey(new KeyConfig2(new File(keyPath), keyPass));
            }
            catch (Throwable t) {
                throw new RuntimeCryptoException("Failed when attempting to load keystore: " + t.getMessage(), t);
            }
        }
    }
}

