/*
 * Decompiled with CFR 0.152.
 */
package net.theblackchamber.crypto.implementations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import net.theblackchamber.crypto.exceptions.MissingParameterException;
import net.theblackchamber.crypto.exceptions.RuntimeCryptoException;
import net.theblackchamber.crypto.exceptions.UnsupportedAlgorithmException;
import net.theblackchamber.crypto.exceptions.UnsupportedKeySizeException;
import net.theblackchamber.crypto.providers.EncryptionProvider;
import net.theblackchamber.crypto.providers.EncryptionProviderFactory;
import net.theblackchamber.crypto.util.KeystoreUtils;
import org.apache.commons.lang3.StringUtils;

public class SecureProperties
extends Properties {
    private static final long serialVersionUID = 6795084558089471182L;
    private static final String ENCRYPTED_SUFFIX = "-encrypted";
    private static final String UNENCRYPTED_SUFFIX = "-unencrypted";
    private Key key = null;
    private EncryptionProvider encryptionProvider = null;

    public Key getKey() {
        return this.key;
    }

    public EncryptionProvider getEncryptionProvider() {
        return this.encryptionProvider;
    }

    public SecureProperties() {
    }

    public SecureProperties(String propertiesPath, String keyPath, String keyEntry, String keyPass) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, UnrecoverableEntryException, IOException {
        super.load(new FileInputStream(new File(propertiesPath)));
        try {
            this.loadKeystore(keyPath, keyPass, keyEntry);
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    public SecureProperties(InputStream inputStream, String keyPath, String keyEntry, String keyPass) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, UnrecoverableEntryException, IOException {
        super.load(inputStream);
        try {
            if (StringUtils.isEmpty((CharSequence)keyPass)) {
                keyPass = this.getProperty("keystore-password");
            }
            if (StringUtils.isEmpty((CharSequence)keyPath)) {
                keyPath = this.getProperty("key-path");
            }
            if (StringUtils.isEmpty((CharSequence)keyEntry)) {
                keyEntry = this.getProperty("entry-name");
            }
            this.loadKeystore(keyPath, keyPass, keyEntry);
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    public SecureProperties(InputStream configInputStream, InputStream keyInputStream, String keyEntry, String keyPass) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, UnrecoverableEntryException, IOException {
        super.load(configInputStream);
        try {
            if (StringUtils.isEmpty((CharSequence)keyPass)) {
                keyPass = this.getProperty("keystore-password");
            }
            if (StringUtils.isEmpty((CharSequence)keyEntry)) {
                keyEntry = this.getProperty("entry-name");
            }
            this.loadKeystore(keyInputStream, keyPass, keyEntry);
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    public SecureProperties(File propertiesFile, String keyPath, String keyEntry, String keyPass) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, UnrecoverableEntryException, IOException {
        super.load(new FileInputStream(propertiesFile));
        try {
            if (StringUtils.isEmpty((CharSequence)keyPass)) {
                keyPass = this.getProperty("keystore-password");
            }
            if (StringUtils.isEmpty((CharSequence)keyPath)) {
                keyPath = this.getProperty("key-path");
            }
            if (StringUtils.isEmpty((CharSequence)keyEntry)) {
                keyEntry = this.getProperty("entry-name");
            }
            this.loadKeystore(keyPath, keyPass, keyEntry);
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    public SecureProperties(Properties defaults, String keyPath, String keyEntry, String keyPass) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, UnrecoverableEntryException, IOException {
        super(defaults);
        try {
            if (StringUtils.isEmpty((CharSequence)keyPass)) {
                keyPass = this.getProperty("keystore-password");
            }
            if (StringUtils.isEmpty((CharSequence)keyPath)) {
                keyPath = this.getProperty("key-path");
            }
            if (StringUtils.isEmpty((CharSequence)keyEntry)) {
                keyEntry = this.getProperty("entry-name");
            }
            this.loadKeystore(keyPath, keyPass, keyEntry);
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    public SecureProperties(String propertiesPath) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, UnrecoverableEntryException, IOException {
        super.load(new FileInputStream(new File(propertiesPath)));
        try {
            this.loadKeystore();
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    public SecureProperties(File propertiesFile) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, UnrecoverableEntryException, IOException {
        super.load(new FileInputStream(propertiesFile));
        try {
            this.loadKeystore();
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    public SecureProperties(Properties defaults) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, UnrecoverableEntryException, IOException {
        super(defaults);
        try {
            this.loadKeystore();
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    public SecureProperties(InputStream inputStream) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, UnrecoverableEntryException, IOException {
        super.load(inputStream);
        try {
            this.loadKeystore();
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        super.load(reader);
        try {
            this.loadKeystore();
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        super.load(inStream);
        try {
            this.loadKeystore();
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    @Override
    public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        super.loadFromXML(in);
        try {
            this.loadKeystore();
            this.initializeEncryptionProvider();
        }
        catch (RuntimeCryptoException rce) {
            throw new IOException(rce);
        }
    }

    @Override
    public String getProperty(String key) {
        String property = super.getProperty(key);
        return this.attemptDecryption(key, property);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String property = this.getProperty(key);
        if (StringUtils.isEmpty((CharSequence)property)) {
            return defaultValue;
        }
        return property;
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        String property;
        if (StringUtils.equalsIgnoreCase((CharSequence)"key-path", (CharSequence)key)) {
            super.setProperty(key, value);
            this.loadKeystore();
            this.initializeEncryptionProvider();
        }
        if (!StringUtils.equals((CharSequence)(property = this.attemptEncryption(key, value)), (CharSequence)value)) {
            key = StringUtils.replace((String)key, (String)UNENCRYPTED_SUFFIX, (String)ENCRYPTED_SUFFIX);
        }
        return super.setProperty(key, property);
    }

    private String attemptDecryption(String key, String property) {
        try {
            if (StringUtils.endsWithIgnoreCase((CharSequence)key, (CharSequence)ENCRYPTED_SUFFIX)) {
                if (this.encryptionProvider == null) {
                    throw new RuntimeCryptoException("No encryption provider configured");
                }
                return this.encryptionProvider.decrypt(property);
            }
            return property;
        }
        catch (MissingParameterException e) {
            throw new RuntimeCryptoException("No value to encrypt specified");
        }
    }

    private String attemptEncryption(String key, String property) {
        try {
            if (StringUtils.endsWithIgnoreCase((CharSequence)key, (CharSequence)UNENCRYPTED_SUFFIX)) {
                if (this.encryptionProvider == null) {
                    throw new RuntimeCryptoException("No encryption provider configured");
                }
                return this.encryptionProvider.encrypt(property);
            }
            return property;
        }
        catch (MissingParameterException mpre) {
            throw new RuntimeCryptoException("No value to decrypt specified.");
        }
    }

    private void initializeEncryptionProvider() {
        if (this.key != null) {
            try {
                this.encryptionProvider = EncryptionProviderFactory.getProvider(this.key);
            }
            catch (UnsupportedKeySizeException e) {
                throw new RuntimeCryptoException(e.getMessage(), e);
            }
            catch (UnsupportedAlgorithmException e) {
                throw new RuntimeCryptoException(e.getMessage(), e);
            }
        }
    }

    private void loadKeystore() {
        String keypath = this.getProperty("key-path");
        String keyEntryName = this.getProperty("entry-name");
        String keyStorePassword = this.getProperty("keystore-password");
        this.loadKeystore(keypath, keyStorePassword, keyEntryName);
    }

    private void loadKeystore(String keyPath, String keyPass, String keyEntry) {
        if (!StringUtils.isEmpty((CharSequence)keyPath)) {
            try {
                this.key = KeystoreUtils.getSecretKey(new File(keyPath), keyEntry, keyPass);
            }
            catch (Throwable t) {
                throw new RuntimeCryptoException("Failed when attempting to load keystore: " + t.getMessage(), t);
            }
        }
    }

    private void loadKeystore(InputStream keyInputStream, String keyPass, String keyEntry) {
        if (keyInputStream != null) {
            try {
                this.key = KeystoreUtils.getSecretKey(keyInputStream, keyEntry, keyPass);
            }
            catch (Throwable t) {
                throw new RuntimeCryptoException("Failed when attempting to load keystore: " + t.getMessage(), t);
            }
        }
    }
}

