/*
 * Decompiled with CFR 0.152.
 */
package net.theblackchamber.crypto.implementations;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.theblackchamber.crypto.exceptions.MissingParameterException;
import net.theblackchamber.crypto.providers.EncryptionProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;

@Deprecated
public class FileEncryptor {
    private EncryptionProvider encryptionProvider;

    public FileEncryptor(EncryptionProvider provider) throws MissingParameterException {
        if (provider == null) {
            throw new MissingParameterException();
        }
        this.encryptionProvider = provider;
    }

    public void encryptFile(File file) throws MissingParameterException, IOException {
        this.encryptFile(file, true);
    }

    public void encryptFile(File file, boolean replace) throws MissingParameterException, IOException {
        if (file == null || !file.exists()) {
            throw new MissingParameterException("File not specified or file does not exist.");
        }
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
        this.encryptStream(fis, baos);
        File tmpEncrypted = File.createTempFile("commonsencryption", RandomStringUtils.randomAlphanumeric((int)10));
        if (!tmpEncrypted.exists()) {
            throw new IOException("Failed to encrypt file.");
        }
        FileOutputStream fos = new FileOutputStream(tmpEncrypted);
        IOUtils.write((byte[])baos.toByteArray(), (OutputStream)fos);
        fos.close();
        if (replace) {
            File bkpFile = FileUtils.getFile((String[])new String[]{file.getAbsolutePath() + ".bkp"});
            FileUtils.moveFile((File)file, (File)bkpFile);
            try {
                FileUtils.moveFile((File)tmpEncrypted, (File)FileUtils.getFile((String[])new String[]{file.getAbsolutePath()}));
            }
            catch (IOException e) {
                throw new IOException("Failed to encrypt file. Existing file saved with \".bkp\": " + e.getMessage(), e);
            }
            bkpFile.delete();
        } else {
            FileUtils.moveFile((File)tmpEncrypted, (File)FileUtils.getFile((String[])new String[]{file.getAbsolutePath() + ".encrypted"}));
        }
    }

    public void encryptStream(InputStream clearInputStream, OutputStream encryptedOutputStream) throws IOException, MissingParameterException {
        byte[] clearBytes = IOUtils.toByteArray((InputStream)clearInputStream);
        byte[] cipherBytes = this.encryptionProvider.encrypt(clearBytes);
        encryptedOutputStream.write(cipherBytes);
        encryptedOutputStream.flush();
        encryptedOutputStream.close();
    }
}

