/*
 * Decompiled with CFR 0.152.
 */
package net.theblackchamber.crypto.constants;

import net.theblackchamber.crypto.exceptions.UnsupportedAlgorithmException;

public enum SupportedKeyGenAlgorithms {
    AES("AES"),
    DES("DESede");

    private String name;

    private SupportedKeyGenAlgorithms(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SupportedKeyGenAlgorithms getAlgorithm(String algorithm) throws UnsupportedAlgorithmException {
        for (SupportedKeyGenAlgorithms supportedAlgorithm : SupportedKeyGenAlgorithms.values()) {
            if (!algorithm.equals(supportedAlgorithm.getName())) continue;
            return supportedAlgorithm;
        }
        throw new UnsupportedAlgorithmException("Algorithm [" + algorithm + "] is unsupported.");
    }
}

