/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);
    private static Indexer defaultIndexer = new DefaultIndexer();
    private static Matcher defaultMatcher = new DefaultMatcher();

    public static Map<String, Object> discoverFields(Class<?> pClazz) {
        return ReflectionUtils.discoverFields(pClazz, defaultMatcher, defaultIndexer);
    }

    public static Map<String, Object> discoverFields(Class<?> pClazz, Matcher pMatcher) {
        return ReflectionUtils.discoverFields(pClazz, pMatcher, defaultIndexer);
    }

    public static Map<String, Object> discoverFields(Class<?> pClazz, Matcher pMatcher, Indexer pIndexer) {
        log.debug("discovering fields on " + pClazz.getName());
        HashMap<String, Object> result = new HashMap<String, Object>();
        Class<?> current = pClazz;
        do {
            Field[] fields = current.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                String fname = fields[i].getName();
                if (!pMatcher.matches(fname)) continue;
                pIndexer.put(result, fname, fields[i]);
                log.debug("discovered field " + fname + " -> " + fields[i]);
            }
        } while ((current = current.getSuperclass()) != null);
        return result;
    }

    public static Map<String, Object> discoverMethods(Class<?> pClazz) {
        return ReflectionUtils.discoverMethods(pClazz, defaultMatcher, defaultIndexer);
    }

    public static Map<String, Object> discoverMethods(Class<?> pClazz, Matcher pMatcher) {
        return ReflectionUtils.discoverMethods(pClazz, pMatcher, defaultIndexer);
    }

    public static Map<String, Object> discoverMethods(Class<?> pClazz, Matcher pMatcher, Indexer pIndexer) {
        log.debug("discovering methods on " + pClazz.getName());
        HashMap<String, Object> result = new HashMap<String, Object>();
        Class<?> current = pClazz;
        do {
            Method[] methods = current.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                String mname = methods[i].getName();
                if (!pMatcher.matches(mname)) continue;
                pIndexer.put(result, mname, methods[i]);
                log.debug("discovered method " + mname + " -> " + methods[i]);
            }
        } while ((current = current.getSuperclass()) != null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object clone(Object o) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(buffer);
        try {
            oos.writeObject(o);
            oos.flush();
        }
        finally {
            oos.close();
        }
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
        try {
            Object object = ois.readObject();
            return object;
        }
        finally {
            ois.close();
        }
    }

    public static String getClassName(Object o) {
        if (o == null) {
            return "unknown";
        }
        return o.getClass().getName() + "@" + o.hashCode();
    }

    public static String getClassLoaderName(Object o) {
        if (o == null) {
            return "unknown";
        }
        return ReflectionUtils.getClassName(o.getClass().getClassLoader());
    }

    public static final String descriptionOfObject(Object o) {
        return ReflectionUtils.getClassName(o) + "/" + ReflectionUtils.getClassLoaderName(o) + " [" + o + "]";
    }

    public static final String descriptionOfClass(Object o) {
        return ReflectionUtils.getClassName(o) + "/" + ReflectionUtils.getClassLoaderName(o);
    }

    public static class DefaultIndexer
    implements Indexer {
        @Override
        public void put(Map<String, Object> pMap, String pKey, Object pObject) {
            pMap.put(pKey, pObject);
        }
    }

    public static class DefaultMatcher
    implements Matcher {
        @Override
        public boolean matches(String pName) {
            return true;
        }
    }

    public static interface Indexer {
        public void put(Map<String, Object> var1, String var2, Object var3);
    }

    public static interface Matcher {
        public boolean matches(String var1);
    }
}

