/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.api;

import org.apache.commons.javaflow.core.Skip;
import org.apache.commons.javaflow.core.StackRecorder;

public final class InterceptorSupport {
    private InterceptorSupport() {
    }

    public static boolean isInstrumented(Object target) {
        if (null == target) {
            return false;
        }
        return InterceptorSupport.isInstrumented(target.getClass());
    }

    public static boolean isInstrumented(Class<?> targetClass) {
        if (null == targetClass) {
            return false;
        }
        return null != targetClass.getAnnotation(Skip.class);
    }

    public static void beforeExecution(Object actualTarget) {
        StackRecorder stackRecorder = StackRecorder.get();
        if (null != stackRecorder && stackRecorder.isRestoring && stackRecorder.hasReference()) {
            stackRecorder.popReference();
            stackRecorder.pushReference(actualTarget);
        }
    }

    public static void afterExecution(Object proxiedTarget) {
        StackRecorder stackRecorder = StackRecorder.get();
        if (null != stackRecorder && stackRecorder.isCapturing) {
            stackRecorder.popReference();
            stackRecorder.pushReference(proxiedTarget);
        }
    }
}

