/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.MemcachedNodeROImpl;
import net.spy.memcached.NodeLocator;

public final class ArrayModNodeLocator
implements NodeLocator {
    private final HashAlgorithm hashAlg;
    private MemcachedNode[] nodes;

    public ArrayModNodeLocator(List<MemcachedNode> n, HashAlgorithm alg) {
        this.nodes = n.toArray(new MemcachedNode[n.size()]);
        this.hashAlg = alg;
    }

    private ArrayModNodeLocator(MemcachedNode[] n, HashAlgorithm alg) {
        this.nodes = n;
        this.hashAlg = alg;
    }

    @Override
    public Collection<MemcachedNode> getAll() {
        return Arrays.asList(this.nodes);
    }

    @Override
    public MemcachedNode getPrimary(String k) {
        return this.nodes[this.getServerForKey(k)];
    }

    @Override
    public Iterator<MemcachedNode> getSequence(String k) {
        return new NodeIterator(this.getServerForKey(k));
    }

    @Override
    public NodeLocator getReadonlyCopy() {
        MemcachedNode[] n = new MemcachedNode[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            n[i] = new MemcachedNodeROImpl(this.nodes[i]);
        }
        return new ArrayModNodeLocator(n, this.hashAlg);
    }

    @Override
    public void updateLocator(List<MemcachedNode> newNodes) {
        this.nodes = newNodes.toArray(new MemcachedNode[newNodes.size()]);
    }

    private int getServerForKey(String key) {
        int rv = (int)(this.hashAlg.hash(key) % (long)this.nodes.length);
        assert (rv >= 0) : "Returned negative key for key " + key;
        assert (rv < this.nodes.length) : "Invalid server number " + rv + " for key " + key;
        return rv;
    }

    class NodeIterator
    implements Iterator<MemcachedNode> {
        private final int start;
        private int next = 0;

        public NodeIterator(int keyStart) {
            this.next = this.start = keyStart;
            this.computeNext();
            assert (this.next >= 0 || ArrayModNodeLocator.this.nodes.length == 1) : "Starting sequence at " + this.start + " of " + ArrayModNodeLocator.access$000(arrayModNodeLocator).length + " next is " + this.next;
        }

        @Override
        public boolean hasNext() {
            return this.next >= 0;
        }

        private void computeNext() {
            if (++this.next >= ArrayModNodeLocator.this.nodes.length) {
                this.next = 0;
            }
            if (this.next == this.start) {
                this.next = -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MemcachedNode next() {
            try {
                MemcachedNode memcachedNode = ArrayModNodeLocator.this.nodes[this.next];
                return memcachedNode;
            }
            finally {
                this.computeNext();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove a node");
        }
    }
}

