/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.modelica.ast;

import net.sourceforge.pmd.lang.modelica.ast.ASTBlockClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTClassClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTClassPrefixes;
import net.sourceforge.pmd.lang.modelica.ast.ASTClassSpecifier;
import net.sourceforge.pmd.lang.modelica.ast.ASTConnectorClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTEncapsulatedClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTExpandableConnectorClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTFunctionClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTModelClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTOperatorClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTOperatorRecordClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTPackageClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTPartialClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTPureClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTRecordClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTTypeClause;
import net.sourceforge.pmd.lang.modelica.ast.AbstractModelicaNode;
import net.sourceforge.pmd.lang.modelica.ast.ModelicaClassSpecifierNode;
import net.sourceforge.pmd.lang.modelica.ast.ModelicaNode;
import net.sourceforge.pmd.lang.modelica.ast.ModelicaVisitor;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaClassSpecialization;

public class ASTClassDefinition
extends AbstractModelicaNode {
    private ASTClassPrefixes prefixes;
    private ModelicaClassSpecialization specialization;
    private ModelicaClassSpecifierNode specifier;

    ASTClassDefinition(int id) {
        super(id);
    }

    public boolean isPartial() {
        return this.prefixes.getFirstChildOfType(ASTPartialClause.class) != null;
    }

    public boolean isEncapsulated() {
        return this.getFirstChildOfType(ASTEncapsulatedClause.class) != null;
    }

    public ModelicaClassSpecialization getSpecialization() {
        return this.specialization;
    }

    public ModelicaClassSpecifierNode getClassSpecifier() {
        return this.specifier;
    }

    private void checkSpecialization(Class<? extends ModelicaNode> clauseClass, ModelicaClassSpecialization restriction) {
        if (this.prefixes.getFirstChildOfType(clauseClass) != null) {
            assert (this.specialization == null);
            this.specialization = restriction;
        }
    }

    private void detectSpecialization() {
        this.checkSpecialization(ASTClassClause.class, ModelicaClassSpecialization.CLASS);
        this.checkSpecialization(ASTModelClause.class, ModelicaClassSpecialization.MODEL);
        this.checkSpecialization(ASTRecordClause.class, ModelicaClassSpecialization.RECORD);
        this.checkSpecialization(ASTOperatorRecordClause.class, ModelicaClassSpecialization.OPERATOR_RECORD);
        this.checkSpecialization(ASTBlockClause.class, ModelicaClassSpecialization.BLOCK);
        this.checkSpecialization(ASTConnectorClause.class, ModelicaClassSpecialization.CONNECTOR);
        this.checkSpecialization(ASTExpandableConnectorClause.class, ModelicaClassSpecialization.EXPANDABLE_CONNECTOR);
        this.checkSpecialization(ASTTypeClause.class, ModelicaClassSpecialization.TYPE);
        this.checkSpecialization(ASTPackageClause.class, ModelicaClassSpecialization.PACKAGE);
        this.checkSpecialization(ASTOperatorClause.class, ModelicaClassSpecialization.OPERATOR);
        ASTFunctionClause functionOrNull = (ASTFunctionClause)this.prefixes.getFirstChildOfType(ASTFunctionClause.class);
        if (functionOrNull != null) {
            boolean isOperator;
            boolean isPure = functionOrNull.getFirstChildOfType(ASTPureClause.class) != null;
            boolean bl = isOperator = functionOrNull.getFirstChildOfType(ASTOperatorClause.class) != null;
            assert (this.specialization == null);
            this.specialization = ModelicaClassSpecialization.getFunctionSpecialization(isPure, isOperator);
        }
        assert (this.specialization != null);
    }

    public void jjtClose() {
        super.jjtClose();
        this.prefixes = (ASTClassPrefixes)this.getFirstChildOfType(ASTClassPrefixes.class);
        this.specifier = (ModelicaClassSpecifierNode)((ASTClassSpecifier)this.getFirstChildOfType(ASTClassSpecifier.class)).getFirstChildOfType(ModelicaClassSpecifierNode.class);
        this.detectSpecialization();
    }

    @Override
    protected <P, R> R acceptModelicaVisitor(ModelicaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }
}

