/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.lang.reflect.Modifier;
import java.util.Objects;
import net.sourceforge.pmd.lang.java.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.internal.UnresolvedClassStore;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JIntersectionType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.TypesFromReflection;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.OptionalBool;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TypeTestUtil {
    private TypeTestUtil() {
    }

    public static boolean isA(@NonNull Class<?> clazz, @Nullable TypeNode node) {
        AssertionUtil.requireParamNotNull((String)"class", clazz);
        return node != null && (TypeTestUtil.hasNoSubtypes(clazz) ? TypeTestUtil.isExactlyA(clazz, node) : TypeTestUtil.isA(clazz, node.getTypeMirror()));
    }

    public static boolean isA(@NonNull Class<?> clazz, @Nullable JTypeMirror type) {
        AssertionUtil.requireParamNotNull((String)"klass", clazz);
        if (type == null) {
            return false;
        }
        JTypeMirror otherType = TypesFromReflection.fromReflect(clazz, type.getTypeSystem());
        if (otherType == null || TypeOps.isUnresolved(type) || TypeTestUtil.hasNoSubtypes(clazz)) {
            return otherType != null && Objects.equals(otherType.getSymbol(), type.getSymbol());
        }
        return TypeTestUtil.isA(otherType, type);
    }

    public static boolean isA(@NonNull String canonicalName, @Nullable TypeNode node) {
        AssertionUtil.requireParamNotNull((String)"canonicalName", (Object)canonicalName);
        AssertionUtil.assertValidJavaBinaryName((CharSequence)canonicalName);
        if (node == null) {
            return false;
        }
        UnresolvedClassStore unresolvedStore = InternalApiBridge.getProcessor(node).getUnresolvedStore();
        return TypeTestUtil.isA(canonicalName, node.getTypeMirror(), unresolvedStore);
    }

    public static boolean isA(@NonNull String canonicalName, @Nullable JTypeMirror thisType) {
        AssertionUtil.requireParamNotNull((String)"canonicalName", (Object)canonicalName);
        return thisType != null && TypeTestUtil.isA(canonicalName, thisType, null);
    }

    public static boolean isA(@NonNull JTypeMirror t1, @Nullable TypeNode t2) {
        return t2 != null && TypeTestUtil.isA(t1, t2.getTypeMirror());
    }

    public static boolean isA(@Nullable JTypeMirror t1, @NonNull JTypeMirror t2) {
        if (t1 == null) {
            return false;
        }
        if (t2.isPrimitive() || t1.isPrimitive()) {
            return t2.equals(t1);
        }
        if (TypeOps.isUnresolved(t2)) {
            return false;
        }
        if (t1.isClassOrInterface() && ((JClassType)t1).getSymbol().isAnonymousClass()) {
            return false;
        }
        if (t2 instanceof JTypeVar) {
            return t1.isTop() || TypeTestUtil.isA(t1, ((JTypeVar)t2).getUpperBound());
        }
        if (t2 instanceof JIntersectionType) {
            for (JTypeMirror subt : ((JIntersectionType)t2).getComponents()) {
                if (!TypeTestUtil.isA(t1, subt)) continue;
                return true;
            }
            return false;
        }
        return t2.isSubtypeOf(t1);
    }

    private static boolean isA(@NonNull String canonicalName, @NonNull JTypeMirror thisType, @Nullable UnresolvedClassStore unresolvedStore) {
        OptionalBool exactMatch = TypeTestUtil.isExactlyAOrAnon(canonicalName, thisType);
        if (exactMatch != OptionalBool.NO) {
            return exactMatch == OptionalBool.YES;
        }
        JTypeDeclSymbol thisClass = thisType.getSymbol();
        if (thisClass != null && thisClass.isUnresolved()) {
            return false;
        }
        TypeSystem ts = thisType.getTypeSystem();
        @Nullable JTypeMirror otherType = TypesFromReflection.loadType(ts, canonicalName, unresolvedStore);
        return TypeTestUtil.isA(otherType, thisType);
    }

    public static boolean isExactlyA(@NonNull Class<?> clazz, @Nullable TypeNode node) {
        AssertionUtil.requireParamNotNull((String)"class", clazz);
        return node != null && TypeTestUtil.isExactlyA(clazz, node.getTypeMirror().getSymbol());
    }

    public static boolean isExactlyA(@NonNull Class<?> klass, @Nullable JTypeMirror type) {
        AssertionUtil.requireParamNotNull((String)"class", klass);
        return type != null && TypeTestUtil.isExactlyA(klass, type.getSymbol());
    }

    public static boolean isExactlyA(@NonNull Class<?> klass, @Nullable JTypeDeclSymbol type) {
        AssertionUtil.requireParamNotNull((String)"klass", klass);
        if (!(type instanceof JClassSymbol)) {
            return false;
        }
        JClassSymbol symClass = (JClassSymbol)type;
        if (klass.isArray()) {
            return symClass.isArray() && TypeTestUtil.isExactlyA(klass.getComponentType(), symClass.getArrayComponent());
        }
        return symClass.getBinaryName().equals(klass.getName());
    }

    public static boolean isDeclaredInClass(@NonNull Class<?> klass, @NonNull JMethodSig sig) {
        return TypeTestUtil.isExactlyA(klass, sig.getDeclaringType().getSymbol());
    }

    public static boolean isExactlyA(@NonNull String canonicalName, @Nullable TypeNode node) {
        AssertionUtil.assertValidJavaBinaryName((CharSequence)canonicalName);
        return node != null && TypeTestUtil.isExactlyAOrAnon(canonicalName, node.getTypeMirror()) == OptionalBool.YES;
    }

    static OptionalBool isExactlyAOrAnon(@NonNull String canonicalName, @NonNull JTypeMirror node) {
        AssertionUtil.requireParamNotNull((String)"canonicalName", (Object)canonicalName);
        JTypeDeclSymbol sym = node.getSymbol();
        if (!(sym instanceof JClassSymbol)) {
            return OptionalBool.NO;
        }
        JClassSymbol klass = (JClassSymbol)sym;
        String canonical = klass.getCanonicalName();
        if (canonical == null) {
            return OptionalBool.UNKNOWN;
        }
        canonicalName = StringUtils.deleteWhitespace((String)canonicalName);
        return OptionalBool.definitely((boolean)canonical.equals(canonicalName));
    }

    private static boolean hasNoSubtypes(Class<?> clazz) {
        return Modifier.isFinal(clazz.getModifiers()) && !clazz.isArray() || clazz.isPrimitive();
    }
}

