/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import net.sourceforge.pmd.util.AssertionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ParseLock {
    private static final Logger LOG = LoggerFactory.getLogger(ParseLock.class);
    private volatile ParseStatus status = ParseStatus.NOT_PARSED;
    private final String name;

    protected ParseLock(String name) {
        this.name = name;
    }

    public void ensureParsed() {
        this.getFinalStatus();
    }

    private void logParseLockTrace(String prefix) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} {}: {}", new Object[]{Thread.currentThread().getName(), String.format("%-15s", prefix), this});
        }
    }

    void checkWeAreNotParsingAnother() {
    }

    void releaseLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseStatus getFinalStatus() {
        ParseStatus status = this.status;
        if (!status.isFinished) {
            this.logParseLockTrace("waiting on");
            try {
                this.checkWeAreNotParsingAnother();
                ParseLock parseLock = this;
                synchronized (parseLock) {
                    this.logParseLockTrace("locked");
                    status = this.status;
                    if (status == ParseStatus.NOT_PARSED) {
                        this.status = ParseStatus.BEING_PARSED;
                        try {
                            boolean success = this.doParse();
                            status = success ? ParseStatus.FULL : ParseStatus.FAILED;
                            this.finishParse(!success);
                        }
                        catch (Throwable t) {
                            status = ParseStatus.FAILED;
                            LOG.error("Parsing failed in ParseLock#doParse() of {}", (Object)this.name, (Object)t);
                            this.finishParse(true);
                        }
                        this.status = status;
                        assert (status.isFinished) : "Inconsistent status " + (Object)((Object)status);
                        assert (this.postCondition()) : "Post condition not satisfied after parsing sig " + this;
                    } else if (status == ParseStatus.BEING_PARSED) {
                        throw new IllegalStateException("Thread is reentering the parse lock " + this);
                    }
                }
            }
            finally {
                this.logParseLockTrace("released");
                this.releaseLock();
            }
        }
        return status;
    }

    public boolean isFailed() {
        return this.getFinalStatus() == ParseStatus.FAILED;
    }

    public boolean isNotParsed() {
        return this.status == ParseStatus.NOT_PARSED;
    }

    protected void finishParse(boolean failed) {
    }

    protected abstract boolean doParse() throws Throwable;

    protected boolean postCondition() {
        return true;
    }

    public String toString() {
        return "ParseLock{name=" + this.name + ",status=" + (Object)((Object)this.status) + '}';
    }

    private static enum ParseStatus {
        NOT_PARSED(false),
        BEING_PARSED(false),
        FULL(true),
        FAILED(true);

        final boolean isFinished;

        private ParseStatus(boolean finished) {
            this.isFinished = finished;
        }
    }

    static abstract class CheckedParseLock
    extends ParseLock {
        private static final ThreadLocal<ParseLock> CURRENT_LOCK = new ThreadLocal();

        protected CheckedParseLock(String name) {
            super(name);
        }

        @Override
        final void checkWeAreNotParsingAnother() {
            if (AssertionUtil.isAssertEnabled()) {
                ParseLock lock = CURRENT_LOCK.get();
                if (lock != null) {
                    throw new AssertionError((Object)("Parsing " + lock + " requested parsing of " + this));
                }
                CURRENT_LOCK.set(this);
            }
        }

        @Override
        final void releaseLock() {
            if (AssertionUtil.isAssertEnabled()) {
                ParseLock lock = CURRENT_LOCK.get();
                assert (lock == this) : "Tried to release different parse lock " + lock + " from " + this;
                CURRENT_LOCK.remove();
            }
        }
    }
}

