/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast.internal;

import net.sourceforge.pmd.lang.java.ast.ASTAmbiguousName;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAccess;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAllocation;
import net.sourceforge.pmd.lang.java.ast.ASTArrayType;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTClassType;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTIntersectionType;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaParameterList;
import net.sourceforge.pmd.lang.java.ast.ASTList;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodReference;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTRecordDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTResource;
import net.sourceforge.pmd.lang.java.ast.ASTSuperExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.ASTThisExpression;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTTypeArguments;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeExpression;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTUnionType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.ASTVoidType;
import net.sourceforge.pmd.lang.java.ast.ASTWildcardType;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.ast.QualifiableExpression;
import net.sourceforge.pmd.lang.java.rule.codestyle.UselessParenthesesRule;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.TypePrettyPrint;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PrettyPrintingUtil {
    private PrettyPrintingUtil() {
    }

    public static String displaySignature(String methodName, ASTFormalParameters params) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName);
        sb.append('(');
        boolean first = true;
        for (ASTFormalParameter param : params) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            PrettyPrintingUtil.prettyPrintTypeNode(sb, param.getTypeNode());
            int extraDimensions = ASTList.sizeOrZero(param.getVarId().getExtraDimensions());
            while (extraDimensions-- > 0) {
                sb.append("[]");
            }
        }
        sb.append(')');
        return sb.toString();
    }

    private static void prettyPrintTypeNode(StringBuilder sb, ASTType t) {
        if (t instanceof ASTPrimitiveType) {
            sb.append(((ASTPrimitiveType)t).getKind().getSimpleName());
        } else if (t instanceof ASTClassType) {
            ASTClassType classT = (ASTClassType)t;
            sb.append(classT.getSimpleName());
            ASTTypeArguments targs = classT.getTypeArguments();
            if (targs != null) {
                sb.append("<");
                CollectionUtil.joinOn((StringBuilder)sb, (Iterable)targs.toStream(), PrettyPrintingUtil::prettyPrintTypeNode, (String)", ");
                sb.append(">");
            }
        } else if (t instanceof ASTArrayType) {
            PrettyPrintingUtil.prettyPrintTypeNode(sb, ((ASTArrayType)t).getElementType());
            int depth = ((ASTArrayType)t).getArrayDepth();
            for (int i = 0; i < depth; ++i) {
                sb.append("[]");
            }
        } else if (t instanceof ASTVoidType) {
            sb.append("void");
        } else if (t instanceof ASTWildcardType) {
            sb.append("?");
            ASTReferenceType bound = ((ASTWildcardType)t).getTypeBoundNode();
            if (bound != null) {
                sb.append(((ASTWildcardType)t).isLowerBound() ? " super " : " extends ");
                PrettyPrintingUtil.prettyPrintTypeNode(sb, bound);
            }
        } else if (t instanceof ASTUnionType) {
            CollectionUtil.joinOn((StringBuilder)sb, ((ASTUnionType)t).getComponents(), PrettyPrintingUtil::prettyPrintTypeNode, (String)" | ");
        } else if (t instanceof ASTIntersectionType) {
            CollectionUtil.joinOn((StringBuilder)sb, ((ASTIntersectionType)t).getComponents(), PrettyPrintingUtil::prettyPrintTypeNode, (String)" & ");
        } else if (t instanceof ASTAmbiguousName) {
            sb.append(((ASTAmbiguousName)t).getName());
        } else {
            throw AssertionUtil.shouldNotReachHere((String)("Unhandled type? " + t));
        }
    }

    public static String prettyPrintType(ASTType t) {
        StringBuilder sb = new StringBuilder();
        PrettyPrintingUtil.prettyPrintTypeNode(sb, t);
        return sb.toString();
    }

    public static String displaySignature(ASTExecutableDeclaration node) {
        return PrettyPrintingUtil.displaySignature(node.getName(), node.getFormalParameters());
    }

    public static String getPrintableNodeKind(ASTTypeDeclaration decl) {
        if (decl instanceof ASTClassDeclaration && decl.isInterface()) {
            return "interface";
        }
        if (decl instanceof ASTAnnotationTypeDeclaration) {
            return "annotation";
        }
        if (decl instanceof ASTEnumDeclaration) {
            return "enum";
        }
        if (decl instanceof ASTRecordDeclaration) {
            return "record";
        }
        return "class";
    }

    public static String getNodeName(JavaNode node) {
        if (node instanceof ASTMethodDeclaration) {
            return ((ASTMethodDeclaration)node).getName();
        }
        if (node instanceof ASTExecutableDeclaration) {
            return PrettyPrintingUtil.displaySignature((ASTConstructorDeclaration)node);
        }
        if (node instanceof ASTFieldDeclaration) {
            return ((ASTVariableId)((ASTFieldDeclaration)node).getVarIds().firstOrThrow()).getName();
        }
        if (node instanceof ASTResource) {
            ASTLocalVariableDeclaration var = ((ASTResource)node).asLocalVariableDeclaration();
            if (var != null) {
                return ((ASTVariableId)var.getVarIds().firstOrThrow()).getName();
            }
            return PrettyPrintingUtil.prettyPrint(((ASTResource)node).getInitializer()).toString();
        }
        if (node instanceof ASTTypeDeclaration) {
            return ((ASTTypeDeclaration)node).getSimpleName();
        }
        if (node instanceof ASTVariableId) {
            return ((ASTVariableId)node).getName();
        }
        throw new IllegalArgumentException("Node has no defined name: " + node);
    }

    public static String getPrintableNodeKind(JavaNode node) {
        if (node instanceof ASTTypeDeclaration) {
            return PrettyPrintingUtil.getPrintableNodeKind((ASTTypeDeclaration)node);
        }
        if (node instanceof ASTMethodDeclaration) {
            return "method";
        }
        if (node instanceof ASTConstructorDeclaration) {
            return "constructor";
        }
        if (node instanceof ASTFieldDeclaration) {
            return "field";
        }
        if (node instanceof ASTResource) {
            return "resource specification";
        }
        throw new UnsupportedOperationException("Node " + node + " is unaccounted for");
    }

    public static String prettyImport(ASTImportDeclaration importDecl) {
        String name = importDecl.getImportedName();
        if (importDecl.isImportOnDemand()) {
            return name + ".*";
        }
        return name;
    }

    public static String prettyPrintAnnot(ASTAnnotation annot) {
        String result = "@" + annot.getSimpleName();
        if (annot.getMembers().isEmpty()) {
            return result;
        }
        return result + "(...)";
    }

    public static @NonNull String prettyPrintOverload(ASTMethodCall it) {
        return PrettyPrintingUtil.prettyPrintOverload(it.getOverloadSelectionInfo().getMethodType());
    }

    public static @NonNull String prettyPrintOverload(JMethodSymbol it) {
        return PrettyPrintingUtil.prettyPrintOverload(it.getTypeSystem().sigOf(it));
    }

    public static @NonNull String prettyPrintOverload(JMethodSig it) {
        return TypePrettyPrint.prettyPrint(it, PrettyPrintingUtil.overloadPrinter());
    }

    private static TypePrettyPrint.TypePrettyPrinter overloadPrinter() {
        return new TypePrettyPrint.TypePrettyPrinter().qualifyNames(false).printMethodResult(false);
    }

    public static CharSequence prettyPrint(JavaNode node) {
        StringBuilder sb = new StringBuilder();
        node.acceptVisitor(new ExprPrinter(), sb);
        return sb;
    }

    static class ExprPrinter
    extends JavaVisitorBase<StringBuilder, Void> {
        private static final int MAX_ARG_LENGTH = 20;
        public static final String BLOCK_PLACEHOLDER = "{ ... }";

        ExprPrinter() {
        }

        @Override
        public Void visitJavaNode(JavaNode node, StringBuilder data) {
            data.append("<<NOT_IMPLEMENTED: ").append(node).append(">>");
            return null;
        }

        @Override
        public Void visit(ASTTypeExpression node, StringBuilder data) {
            node.getTypeNode().acceptVisitor(this, data);
            return null;
        }

        @Override
        public Void visit(ASTCastExpression node, StringBuilder data) {
            this.ppInParens(data, node.getCastType()).append(' ');
            node.getOperand().acceptVisitor(this, data);
            return null;
        }

        @Override
        public Void visit(ASTClassLiteral node, StringBuilder data) {
            node.getTypeNode().acceptVisitor(this, data);
            data.append(".class");
            return null;
        }

        @Override
        public Void visitLiteral(ASTLiteral node, StringBuilder data) {
            data.append((CharSequence)node.getLiteralText());
            return null;
        }

        @Override
        public Void visit(ASTFieldAccess node, StringBuilder data) {
            this.addQualifier(node, data);
            data.append(node.getName());
            return null;
        }

        @Override
        public Void visit(ASTVariableAccess node, StringBuilder data) {
            data.append(node.getName());
            return null;
        }

        @Override
        public Void visit(ASTThisExpression node, StringBuilder data) {
            if (node.getQualifier() != null) {
                ((AbstractJavaNode)node.getQualifier()).acceptVisitor(this, data);
                data.append('.');
            }
            data.append("this");
            return null;
        }

        @Override
        public Void visit(ASTSuperExpression node, StringBuilder data) {
            if (node.getQualifier() != null) {
                ((AbstractJavaNode)node.getQualifier()).acceptVisitor(this, data);
                data.append('.');
            }
            data.append("super");
            return null;
        }

        @Override
        public Void visit(ASTArrayAccess node, StringBuilder data) {
            node.getQualifier().acceptVisitor(this, data);
            data.append('[');
            node.getIndexExpression().acceptVisitor(this, data);
            data.append(']');
            return null;
        }

        @Override
        public Void visitType(ASTType node, StringBuilder data) {
            PrettyPrintingUtil.prettyPrintTypeNode(data, node);
            return null;
        }

        @Override
        public Void visit(ASTAmbiguousName node, StringBuilder data) {
            data.append(node.getName());
            return null;
        }

        @Override
        public Void visit(ASTInfixExpression node, StringBuilder sb) {
            this.printWithParensIfNecessary(node.getLeftOperand(), sb, node);
            sb.append(' ');
            sb.append(node.getOperator());
            sb.append(' ');
            this.printWithParensIfNecessary(node.getRightOperand(), sb, node);
            return null;
        }

        @Override
        public Void visit(ASTUnaryExpression node, StringBuilder sb) {
            boolean prefix = node.getOperator().isPrefix();
            if (prefix) {
                sb.append(node.getOperator());
            }
            this.printWithParensIfNecessary(node.getOperand(), sb, node);
            if (!prefix) {
                sb.append(node.getOperator());
            }
            return null;
        }

        private void printWithParensIfNecessary(ASTExpression operand, StringBuilder sb, ASTExpression parent) {
            if (operand.isParenthesized() && UselessParenthesesRule.needsParentheses(operand, parent) != UselessParenthesesRule.Necessity.NEVER) {
                this.ppInParens(sb, operand);
            } else {
                operand.acceptVisitor(this, sb);
            }
        }

        @Override
        public Void visit(ASTConditionalExpression node, StringBuilder sb) {
            this.printWithParensIfNecessary(node.getCondition(), sb, node);
            sb.append(" ? ");
            this.printWithParensIfNecessary(node.getThenBranch(), sb, node);
            sb.append(" : ");
            this.printWithParensIfNecessary(node.getElseBranch(), sb, node);
            return null;
        }

        @Override
        public Void visit(ASTLambdaExpression node, StringBuilder sb) {
            ((AbstractJavaNode)node.getParameters()).acceptVisitor(this, sb);
            sb.append(" -> ");
            ASTExpression exprBody = node.getExpressionBody();
            if (exprBody != null) {
                exprBody.acceptVisitor(this, sb);
            } else {
                sb.append(BLOCK_PLACEHOLDER);
            }
            return null;
        }

        @Override
        public Void visit(ASTLambdaParameterList node, StringBuilder sb) {
            if (node.size() == 1) {
                sb.append(((ASTLambdaParameter)node.get(0)).getVarId().getName());
                return null;
            }
            if (node.isEmpty()) {
                sb.append("()");
                return null;
            }
            sb.append('(');
            sb.append(((ASTLambdaParameter)node.get(0)).getVarId().getName());
            node.toStream().drop(1).forEach(it -> {
                sb.append(", ");
                sb.append(it.getVarId().getName());
            });
            sb.append(')');
            return null;
        }

        @Override
        public Void visit(ASTMethodCall node, StringBuilder sb) {
            this.addQualifier(node, sb);
            this.ppTypeArgs(sb, node.getExplicitTypeArguments());
            sb.append(node.getMethodName());
            this.ppArguments(sb, node.getArguments());
            return null;
        }

        @Override
        public Void visit(ASTConstructorCall node, StringBuilder sb) {
            this.addQualifier(node, sb);
            sb.append("new ");
            this.ppTypeArgs(sb, node.getExplicitTypeArguments());
            PrettyPrintingUtil.prettyPrintTypeNode(sb, node.getTypeNode());
            this.ppArguments(sb, node.getArguments());
            return null;
        }

        private void ppArguments(StringBuilder sb, ASTArgumentList arguments) {
            if (arguments.isEmpty()) {
                sb.append("()");
            } else {
                int argStart = sb.length();
                sb.append('(');
                boolean first = true;
                for (ASTExpression arg : arguments) {
                    if (sb.length() - argStart >= 20) {
                        sb.append("...");
                        break;
                    }
                    if (!first) {
                        sb.append(", ");
                    }
                    arg.acceptVisitor(this, sb);
                    first = false;
                }
                sb.append(')');
            }
        }

        @Override
        public Void visit(ASTMethodReference node, StringBuilder sb) {
            this.printWithParensIfNecessary(node.getQualifier(), sb, node);
            sb.append("::");
            this.ppTypeArgs(sb, node.getExplicitTypeArguments());
            sb.append(node.getMethodName());
            return null;
        }

        @Override
        public Void visit(ASTAssignmentExpression node, StringBuilder sb) {
            node.getLeftOperand().acceptVisitor(this, sb);
            sb.append(" = ");
            node.getRightOperand().acceptVisitor(this, sb);
            return null;
        }

        @Override
        public Void visit(ASTSwitchExpression node, StringBuilder sb) {
            sb.append("switch (");
            ((JavaNode)node.getFirstChild()).acceptVisitor(this, sb);
            sb.append(") ").append(BLOCK_PLACEHOLDER);
            return null;
        }

        @Override
        public Void visit(ASTArrayAllocation node, StringBuilder sb) {
            sb.append("new ");
            node.getTypeNode().getElementType().acceptVisitor(this, sb);
            node.getTypeNode().getDimensions().children().forEach(child -> {
                sb.append('[');
                JavaNode firstChild = (JavaNode)child.getFirstChild();
                if (firstChild != null) {
                    firstChild.acceptVisitor(this, sb);
                }
                sb.append(']');
            });
            if (node.getArrayInitializer() != null) {
                sb.append(node.getArrayInitializer().length() == 0 ? "{}" : BLOCK_PLACEHOLDER);
            }
            return null;
        }

        private void addQualifier(QualifiableExpression node, StringBuilder data) {
            ASTExpression qualifier = node.getQualifier();
            if (qualifier != null) {
                this.printWithParensIfNecessary(qualifier, data, node);
                data.append('.');
            }
        }

        private StringBuilder ppInParens(StringBuilder data, JavaNode qualifier) {
            data.append('(');
            qualifier.acceptVisitor(this, data);
            return data.append(')');
        }

        private void ppTypeArgs(StringBuilder data, @Nullable ASTTypeArguments targs) {
            if (targs == null) {
                return;
            }
            data.append('<');
            PrettyPrintingUtil.prettyPrintTypeNode(data, (ASTType)targs.get(0));
            for (int i = 1; i < targs.size(); ++i) {
                data.append(", ");
                PrettyPrintingUtil.prettyPrintTypeNode(data, (ASTType)targs.get(i));
            }
            data.append('>');
        }
    }
}

