/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterOwnerSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AsmStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ClassStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ExecutableStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.GenericTypeParameterCounter;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ParseLock;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.SignatureParser;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.TParamStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.TypeAnnotationHelper;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.TypeAnnotationReceiver;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.LexicalScope;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class GenericSigBase<T extends JTypeParameterOwnerSymbol & AsmStub> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericSigBase.class);
    protected final T ctx;
    protected List<JTypeVar> typeParameters;
    private final ParseLock lock;

    protected GenericSigBase(T ctx, String parseLockName) {
        this.ctx = ctx;
        this.lock = new ParseLock(parseLockName, (JTypeParameterOwnerSymbol)ctx){
            final /* synthetic */ JTypeParameterOwnerSymbol val$ctx;
            {
                this.val$ctx = jTypeParameterOwnerSymbol;
                super(name);
            }

            @Override
            protected boolean doParse() {
                try {
                    GenericSigBase.this.doParse();
                    return true;
                }
                catch (RuntimeException e) {
                    throw AssertionUtil.contexted((RuntimeException)e).addContextValue("signature", (Object)GenericSigBase.this).addContextValue("owner class", (Object)this.val$ctx.getEnclosingClass()).addContextValue("owner name", (Object)this.val$ctx.getSimpleName()).addContextValue("owner package", (Object)this.val$ctx.getPackageName());
                }
            }

            @Override
            protected boolean postCondition() {
                return GenericSigBase.this.postCondition();
            }

            @Override
            protected void finishParse(boolean failed) {
                GenericSigBase.this.typeParameters.forEach(tp -> ((TParamStub)tp.getSymbol()).setCanComputeBound());
            }
        };
    }

    LexicalScope getEnclosingTypeParams() {
        JTypeParameterOwnerSymbol enclosing = this.ctx.getEnclosingTypeParameterOwner();
        return enclosing == null ? LexicalScope.EMPTY : enclosing.getLexicalScope();
    }

    protected final void ensureParsed() {
        this.lock.ensureParsed();
    }

    protected abstract void doParse();

    protected abstract boolean postCondition();

    protected abstract int getTypeParameterCount();

    protected boolean isGeneric() {
        return this.getTypeParameterCount() > 0;
    }

    public void setTypeParams(List<JTypeVar> tvars) {
        assert (this.typeParameters == null) : "Type params were already parsed for " + this;
        this.typeParameters = tvars;
    }

    public List<JTypeVar> getTypeParams() {
        this.ensureParsed();
        return this.typeParameters;
    }

    public SignatureParser typeLoader() {
        return ((AsmStub)this.ctx).sigParser();
    }

    static class LazyMethodType
    extends GenericSigBase<ExecutableStub>
    implements TypeAnnotationReceiver {
        private final @NonNull String signature;
        private final int typeParameterCount;
        private @Nullable TypeAnnotationHelper.TypeAnnotationSet receiverAnnotations;
        private List<JTypeMirror> parameterTypes;
        private List<JTypeMirror> exceptionTypes;
        private JTypeMirror returnType;
        private @Nullable TypeAnnotationHelper.TypeAnnotationSetWithReferences typeAnnots;
        private @Nullable String[] rawExceptions;
        private final boolean skipFirstParam;

        LazyMethodType(ExecutableStub ctx, @NonNull String descriptor, @Nullable String genericSig, @Nullable String[] exceptions, boolean skipFirstParam) {
            super(ctx, "LazyMethodType:" + (genericSig != null ? genericSig : descriptor));
            this.signature = genericSig != null ? genericSig : descriptor;
            this.typeParameterCount = GenericTypeParameterCounter.determineTypeParameterCount(genericSig);
            this.skipFirstParam = skipFirstParam && genericSig == null;
            this.rawExceptions = exceptions;
        }

        @Override
        protected void doParse() {
            ((ExecutableStub)this.ctx).sigParser().parseMethodType(this, this.signature);
            if (this.rawExceptions != null && this.exceptionTypes.isEmpty()) {
                this.exceptionTypes = (List)Arrays.stream(this.rawExceptions).map(((ExecutableStub)this.ctx).getResolver()::resolveFromInternalNameCannotFail).map(((ExecutableStub)this.ctx).getTypeSystem()::rawType).collect(CollectionUtil.toUnmodifiableList());
            }
            if (this.ctx instanceof ExecutableStub.CtorStub) {
                assert (this.returnType.isVoid());
                this.returnType = ((ExecutableStub)this.ctx).getTypeSystem().declaration(((ExecutableStub)this.ctx).getEnclosingClass());
            }
            if (this.typeAnnots != null) {
                this.typeAnnots.forEach(this::acceptAnnotationAfterParse);
            }
            this.rawExceptions = null;
            this.typeAnnots = null;
        }

        public JTypeMirror applyReceiverAnnotations(JTypeMirror typeMirror) {
            if (this.receiverAnnotations == null) {
                return typeMirror;
            }
            return this.receiverAnnotations.decorate(typeMirror);
        }

        @Override
        protected boolean postCondition() {
            return this.parameterTypes != null && this.exceptionTypes != null && this.returnType != null;
        }

        @Override
        protected int getTypeParameterCount() {
            return this.typeParameterCount;
        }

        void setParameterTypes(List<JTypeMirror> params) {
            Validate.validState((this.parameterTypes == null ? 1 : 0) != 0);
            this.parameterTypes = this.skipFirstParam ? params.subList(1, params.size()) : params;
        }

        void setExceptionTypes(List<JTypeMirror> exs) {
            Validate.validState((this.exceptionTypes == null ? 1 : 0) != 0);
            this.exceptionTypes = exs;
        }

        void setReturnType(JTypeMirror returnType) {
            Validate.validState((this.returnType == null ? 1 : 0) != 0);
            this.returnType = returnType;
        }

        public List<JTypeMirror> getParameterTypes() {
            this.ensureParsed();
            return this.parameterTypes;
        }

        public List<JTypeMirror> getExceptionTypes() {
            this.ensureParsed();
            return this.exceptionTypes;
        }

        public JTypeMirror getReturnType() {
            this.ensureParsed();
            return this.returnType;
        }

        public String toString() {
            return this.signature;
        }

        @Override
        public void acceptTypeAnnotation(int typeRefInt, @Nullable TypePath path, SymbolicValue.SymAnnot annot) {
            if (this.typeAnnots == null) {
                this.typeAnnots = new TypeAnnotationHelper.TypeAnnotationSetWithReferences();
            }
            this.typeAnnots.add(new TypeReference(typeRefInt), path, annot);
        }

        boolean acceptAnnotationAfterParse(TypeReference tyRef, @Nullable TypePath path, SymbolicValue.SymAnnot annot) {
            switch (tyRef.getSort()) {
                case 20: {
                    assert (this.returnType != null) : "Return type is not set";
                    this.returnType = TypeAnnotationHelper.applySinglePath(this.returnType, path, annot);
                    return false;
                }
                case 22: {
                    assert (this.parameterTypes != null) : "Parameter types are not set";
                    int idx = tyRef.getFormalParameterIndex();
                    JTypeMirror annotatedFormal = TypeAnnotationHelper.applySinglePath(this.parameterTypes.get(idx), path, annot);
                    this.parameterTypes = TypeAnnotationHelper.replaceAtIndex(this.parameterTypes, idx, annotatedFormal);
                    return false;
                }
                case 23: {
                    assert (this.exceptionTypes != null) : "Exception types are not set";
                    int idx = tyRef.getExceptionIndex();
                    JTypeMirror annotatedFormal = TypeAnnotationHelper.applySinglePath(this.exceptionTypes.get(idx), path, annot);
                    this.exceptionTypes = TypeAnnotationHelper.replaceAtIndex(this.exceptionTypes, idx, annotatedFormal);
                    return false;
                }
                case 1: {
                    assert (this.typeParameters != null);
                    assert (path == null) : "unexpected path " + path;
                    int idx = tyRef.getTypeParameterIndex();
                    ((TParamStub)((JTypeVar)this.typeParameters.get(idx)).getSymbol()).addAnnotation(annot);
                    return false;
                }
                case 18: {
                    assert (this.typeParameters != null);
                    int tparamIdx = tyRef.getTypeParameterIndex();
                    JTypeVar tparam = (JTypeVar)this.typeParameters.get(tparamIdx);
                    TParamStub sym = (TParamStub)tparam.getSymbol();
                    assert (sym != null);
                    sym.addAnnotationOnBound(tyRef, path, annot);
                    return false;
                }
                case 21: {
                    if (this.receiverAnnotations == null) {
                        this.receiverAnnotations = new TypeAnnotationHelper.TypeAnnotationSet();
                    }
                    this.receiverAnnotations.add(path, annot);
                    return false;
                }
                case 16: {
                    LOGGER.debug("Invalid target type CLASS_EXTENDS of type annotation {} for method or ctor detected. The annotation is ignored. Method: {}#{}. See https://github.com/pmd/pmd/issues/5344.", new Object[]{annot, ((ExecutableStub)this.ctx).getEnclosingClass().getCanonicalName(), ((ExecutableStub)this.ctx).getSimpleName()});
                    return false;
                }
            }
            throw new IllegalArgumentException("Invalid target type of type annotation " + annot + " for method or ctor type annotation: " + tyRef.getSort());
        }
    }

    static class LazyClassSignature
    extends GenericSigBase<ClassStub> {
        private static final String OBJECT_INTERNAL_NAME = "java/lang/Object";
        private static final String OBJECT_SIG = "Ljava/lang/Object;";
        private static final String OBJECT_BOUND = ":Ljava/lang/Object;";
        private final @Nullable String signature;
        private final int typeParameterCount;
        private @Nullable JClassType superType;
        private List<JClassType> superItfs;
        private final List<JClassSymbol> rawItfs;
        private final @Nullable JClassSymbol rawSuper;

        LazyClassSignature(ClassStub ctx, @Nullable String signature, @Nullable String superInternalName, String[] interfaces) {
            super(ctx, "LazyClassSignature:" + ctx.getInternalName() + "[" + signature + "]");
            this.signature = signature;
            this.typeParameterCount = GenericTypeParameterCounter.determineTypeParameterCount(this.signature);
            this.rawItfs = CollectionUtil.map((Object[])interfaces, ctx.getResolver()::resolveFromInternalNameCannotFail);
            this.rawSuper = ctx.getResolver().resolveFromInternalNameCannotFail(superInternalName);
        }

        static LazyClassSignature defaultWhenUnresolved(ClassStub ctx, int observedArity) {
            String sig = LazyClassSignature.sigWithNTypeParams(observedArity);
            return new LazyClassSignature(ctx, sig, OBJECT_INTERNAL_NAME, null);
        }

        private static @NonNull String sigWithNTypeParams(int observedArity) {
            assert (observedArity >= 0);
            switch (observedArity) {
                case 0: {
                    return OBJECT_SIG;
                }
                case 1: {
                    return "<T0:Ljava/lang/Object;>Ljava/lang/Object;";
                }
                case 2: {
                    return "<T0:Ljava/lang/Object;T1:Ljava/lang/Object;>Ljava/lang/Object;";
                }
            }
            return Stream.iterate(0, i -> i + 1).limit(observedArity).map(i -> "T" + i + OBJECT_BOUND).collect(Collectors.joining("", "<", ">Ljava/lang/Object;"));
        }

        @Override
        protected void doParse() {
            if (this.signature == null) {
                this.superType = this.rawSuper == null ? null : (JClassType)((ClassStub)this.ctx).getTypeSystem().rawType(this.rawSuper);
                this.superItfs = CollectionUtil.map(this.rawItfs, klass -> (JClassType)((ClassStub)this.ctx).getTypeSystem().rawType((JTypeDeclSymbol)klass));
                this.setTypeParams(Collections.emptyList());
            } else {
                ((ClassStub)this.ctx).sigParser().parseClassSignature(this, this.signature);
            }
        }

        @Override
        protected int getTypeParameterCount() {
            return this.typeParameterCount;
        }

        @Override
        protected boolean postCondition() {
            return this.superItfs != null && (this.superType != null || this.signature == null) && this.typeParameters != null;
        }

        void setSuperInterfaces(List<JClassType> supers) {
            Validate.validState((this.superItfs == null ? 1 : 0) != 0);
            this.superItfs = supers;
        }

        void setSuperClass(JClassType sup) {
            Validate.validState((this.superType == null ? 1 : 0) != 0);
            this.superType = sup;
        }

        public JClassType getSuperType(Substitution subst) {
            this.ensureParsed();
            return this.superType == null ? null : this.superType.subst((Function)subst);
        }

        public List<JClassType> getSuperItfs(Substitution subst) {
            this.ensureParsed();
            return TypeOps.substClasses(this.superItfs, subst);
        }

        public @Nullable JClassSymbol getRawSuper() {
            return this.rawSuper;
        }

        public List<JClassSymbol> getRawItfs() {
            return this.rawItfs;
        }

        public String toString() {
            return this.signature;
        }
    }
}

