/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.RuleContext;

public class ArrayIsStoredDirectlyRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Boolean> ALLOW_PRIVATE = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowPrivate").defaultValue((Object)true)).desc("If true, allow private methods/constructors to store arrays directly")).build();

    public ArrayIsStoredDirectlyRule() {
        super(ASTMethodDeclaration.class, ASTConstructorDeclaration.class);
        this.definePropertyDescriptor(ALLOW_PRIVATE);
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.checkAssignments((RuleContext)data, node);
        return data;
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        this.checkAssignments((RuleContext)data, node);
        return data;
    }

    private void checkAssignments(RuleContext context, ASTExecutableDeclaration method) {
        if (method.getVisibility() == ModifierOwner.Visibility.V_PRIVATE && ((Boolean)this.getProperty(ALLOW_PRIVATE)).booleanValue() || method.getBody() == null) {
            return;
        }
        for (ASTFormalParameter formal : method.getFormalParameters()) {
            if (!formal.getTypeMirror().isArray()) continue;
            for (ASTAssignableExpr.ASTNamedReferenceExpr usage : formal.getVarId().getLocalUsages()) {
                ASTAssignableExpr assigned;
                if (usage.getAccessType() == ASTAssignableExpr.AccessType.WRITE) break;
                if (!(usage.getParent() instanceof ASTAssignmentExpression) || usage.getIndexInParent() != 1 || !JavaAstUtils.isRefToFieldOfThisInstance(assigned = ((ASTAssignmentExpression)usage.getParent()).getLeftOperand())) continue;
                context.addViolation((Node)usage.getParent(), new Object[]{usage.getName()});
            }
        }
    }
}

